/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class SparkClientUtilities {
    protected static final transient Log LOG = LogFactory.getLog(SparkClientUtilities.class);

    public static void addToClassPath(String[] newPaths, Configuration conf, File localTmpDir) throws Exception {
        ClassLoader cloader = Thread.currentThread().getContextClassLoader();
        URLClassLoader loader = (URLClassLoader)cloader;
        ArrayList curPath = Lists.newArrayList((Object[])loader.getURLs());
        for (String newPath : newPaths) {
            URL newUrl = SparkClientUtilities.urlFromPathString(newPath, conf, localTmpDir);
            if (newUrl == null || curPath.contains(newUrl)) continue;
            curPath.add(newUrl);
            LOG.info((Object)("Added jar[" + newUrl + "] to classpath."));
        }
        URLClassLoader newLoader = new URLClassLoader(curPath.toArray(new URL[curPath.size()]), (ClassLoader)loader);
        Thread.currentThread().setContextClassLoader(newLoader);
    }

    private static URL urlFromPathString(String path, Configuration conf, File localTmpDir) {
        URL url = null;
        try {
            if (StringUtils.indexOf((String)path, (String)"file:/") == 0) {
                url = new URL(path);
            } else {
                if (StringUtils.indexOf((String)path, (String)"hdfs:/") == 0) {
                    Path remoteFile = new Path(path);
                    Path localFile = new Path(localTmpDir.getAbsolutePath() + File.separator + remoteFile.getName());
                    LOG.info((Object)("Copying " + remoteFile + " to " + localFile));
                    FileSystem fs = remoteFile.getFileSystem(conf);
                    fs.copyToLocalFile(remoteFile, localFile);
                    return SparkClientUtilities.urlFromPathString(localFile.toString(), conf, localTmpDir);
                }
                url = new File(path).toURL();
            }
        }
        catch (Exception err) {
            LOG.error((Object)("Bad URL " + path + ", ignoring path"), (Throwable)err);
        }
        return url;
    }
}

