/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.api;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.callbacks.Callback;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.OpenApiCustomiser;
import org.springdoc.core.AbstractRequestBuilder;
import org.springdoc.core.AbstractResponseBuilder;
import org.springdoc.core.MethodAttributes;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;

public abstract class AbstractOpenApiResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOpenApiResource.class);
    final OpenAPIBuilder openAPIBuilder;
    private final AbstractRequestBuilder requestBuilder;
    private final AbstractResponseBuilder responseBuilder;
    private final OperationBuilder operationParser;
    private final Optional<List<OpenApiCustomiser>> openApiCustomisers;
    private boolean computeDone;

    protected AbstractOpenApiResource(OpenAPIBuilder openAPIBuilder, AbstractRequestBuilder requestBuilder, AbstractResponseBuilder responseBuilder, OperationBuilder operationParser, Optional<List<OpenApiCustomiser>> openApiCustomisers) {
        this.openAPIBuilder = openAPIBuilder;
        this.requestBuilder = requestBuilder;
        this.responseBuilder = responseBuilder;
        this.operationParser = operationParser;
        this.openApiCustomisers = openApiCustomisers;
    }

    protected OpenAPI getOpenApi() {
        OpenAPI openApi;
        if (!this.computeDone) {
            Instant start = Instant.now();
            this.openAPIBuilder.build();
            Map<String, Object> restControllersMap = this.openAPIBuilder.getRestControllersMap();
            Map<String, Object> requestMappingMap = this.openAPIBuilder.getRequestMappingMap();
            Map<String, Object> restControllers = Stream.of(restControllersMap, requestMappingMap).flatMap(mapEl -> mapEl.entrySet().stream()).filter(controller -> AnnotationUtils.findAnnotation(controller.getValue().getClass(), Hidden.class) == null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
            Map<String, Object> findControllerAdvice = this.openAPIBuilder.getControllerAdviceMap();
            this.responseBuilder.buildGenericResponse(this.openAPIBuilder.getComponents(), findControllerAdvice);
            this.getPaths(restControllers);
            openApi = this.openAPIBuilder.getOpenAPI();
            this.openApiCustomisers.ifPresent(apiCustomisers -> apiCustomisers.forEach(openApiCustomiser -> openApiCustomiser.customise(openApi)));
            LOGGER.info("Init duration for springdoc-openapi is: {} ms", (Object)Duration.between(start, Instant.now()).toMillis());
            this.computeDone = true;
        } else {
            openApi = this.openAPIBuilder.getOpenAPI();
        }
        return openApi;
    }

    protected abstract void getPaths(Map<String, Object> var1);

    protected void calculatePath(OpenAPIBuilder openAPIBuilder, HandlerMethod handlerMethod, String operationPath, Set<RequestMethod> requestMethods) {
        OpenAPI openAPI = openAPIBuilder.getOpenAPI();
        Components components = openAPIBuilder.getComponents();
        Paths paths = openAPIBuilder.getPaths();
        Map operationMap = null;
        if (paths.containsKey((Object)operationPath)) {
            PathItem pathItem = (PathItem)paths.get((Object)operationPath);
            operationMap = pathItem.readOperationsMap();
        }
        for (RequestMethod requestMethod : requestMethods) {
            Operation operation;
            Operation existingOperation = this.getExistingOperation(operationMap, requestMethod);
            Method method = handlerMethod.getMethod();
            if (this.operationParser.isHidden(method)) continue;
            RequestMapping reqMappringClass = (RequestMapping)ReflectionUtils.getAnnotation((Class)handlerMethod.getBeanType(), RequestMapping.class);
            MethodAttributes methodAttributes = new MethodAttributes();
            methodAttributes.setMethodOverloaded(existingOperation != null);
            if (reqMappringClass != null) {
                methodAttributes.setClassConsumes(reqMappringClass.consumes());
                methodAttributes.setClassProduces(reqMappringClass.produces());
            }
            methodAttributes.calculateConsumesProduces(method);
            Operation operation2 = operation = existingOperation != null ? existingOperation : new Operation();
            if (ReflectionUtils.getAnnotation((Method)method, Deprecated.class) != null) {
                operation.setDeprecated(Boolean.valueOf(true));
            }
            operation = openAPIBuilder.buildTags(handlerMethod, operation, openAPI);
            io.swagger.v3.oas.annotations.Operation apiOperation = (io.swagger.v3.oas.annotations.Operation)ReflectionUtils.getAnnotation((Method)method, io.swagger.v3.oas.annotations.Operation.class);
            this.calculateJsonView(apiOperation, methodAttributes, method);
            if (apiOperation != null) {
                openAPI = this.operationParser.parse(components, apiOperation, operation, openAPI, methodAttributes);
            }
            RequestBody requestBodyDoc = (RequestBody)ReflectionUtils.getAnnotation((Method)method, RequestBody.class);
            this.requestBuilder.getRequestBodyBuilder().buildRequestBodyFromDoc(requestBodyDoc, methodAttributes.getClassConsumes(), methodAttributes.getMethodConsumes(), components, methodAttributes.getJsonViewAnnotationForRequestBody()).ifPresent(arg_0 -> ((Operation)operation).setRequestBody(arg_0));
            operation = this.requestBuilder.build(components, handlerMethod, requestMethod, operation, methodAttributes);
            ApiResponses apiResponses = this.responseBuilder.build(components, handlerMethod, operation, methodAttributes);
            operation.setResponses(apiResponses);
            List apiCallbacks = ReflectionUtils.getRepeatableAnnotations((Method)method, Callback.class);
            if (apiCallbacks != null) {
                this.operationParser.buildCallbacks(apiCallbacks, components, openAPI, methodAttributes).ifPresent(arg_0 -> ((Operation)operation).setCallbacks(arg_0));
            }
            PathItem pathItemObject = this.buildPathItem(requestMethod, operation, operationPath, paths);
            paths.addPathItem(operationPath, pathItemObject);
        }
    }

    private void calculateJsonView(io.swagger.v3.oas.annotations.Operation apiOperation, MethodAttributes methodAttributes, Method method) {
        JsonView jsonViewAnnotationForRequestBody;
        JsonView jsonViewAnnotation;
        if (apiOperation != null && apiOperation.ignoreJsonView()) {
            jsonViewAnnotation = null;
            jsonViewAnnotationForRequestBody = null;
        } else {
            jsonViewAnnotation = (JsonView)ReflectionUtils.getAnnotation((Method)method, JsonView.class);
            jsonViewAnnotationForRequestBody = (JsonView)Arrays.stream(ReflectionUtils.getParameterAnnotations((Method)method)).filter(arr -> Arrays.stream(arr).anyMatch(annotation -> annotation.annotationType().equals(RequestBody.class))).flatMap(Arrays::stream).filter(annotation -> annotation.annotationType().equals(JsonView.class)).reduce((a, b) -> null).orElse((Annotation)jsonViewAnnotation);
        }
        methodAttributes.setJsonViewAnnotation(jsonViewAnnotation);
        methodAttributes.setJsonViewAnnotationForRequestBody(jsonViewAnnotationForRequestBody);
    }

    private Operation getExistingOperation(Map<PathItem.HttpMethod, Operation> operationMap, RequestMethod requestMethod) {
        Operation existingOperation = null;
        if (!CollectionUtils.isEmpty(operationMap)) {
            switch (requestMethod) {
                case GET: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.GET);
                    break;
                }
                case POST: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.POST);
                    break;
                }
                case PUT: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.PUT);
                    break;
                }
                case DELETE: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.DELETE);
                    break;
                }
                case PATCH: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.PATCH);
                    break;
                }
                case HEAD: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.HEAD);
                    break;
                }
                case OPTIONS: {
                    existingOperation = operationMap.get(PathItem.HttpMethod.OPTIONS);
                    break;
                }
            }
        }
        return existingOperation;
    }

    private PathItem buildPathItem(RequestMethod requestMethod, Operation operation, String operationPath, Paths paths) {
        PathItem pathItemObject = paths.containsKey((Object)operationPath) ? (PathItem)paths.get((Object)operationPath) : new PathItem();
        switch (requestMethod) {
            case POST: {
                pathItemObject.post(operation);
                break;
            }
            case GET: {
                pathItemObject.get(operation);
                break;
            }
            case DELETE: {
                pathItemObject.delete(operation);
                break;
            }
            case PUT: {
                pathItemObject.put(operation);
                break;
            }
            case PATCH: {
                pathItemObject.patch(operation);
                break;
            }
            case TRACE: {
                pathItemObject.trace(operation);
                break;
            }
            case HEAD: {
                pathItemObject.head(operation);
                break;
            }
            case OPTIONS: {
                pathItemObject.options(operation);
                break;
            }
        }
        return pathItemObject;
    }
}

