/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.support.MergedTestPropertySources;
import org.springframework.test.context.support.TestPropertySourceAttributes;
import org.springframework.test.context.util.TestContextResourceUtils;
import org.springframework.test.util.MetaAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class TestPropertySourceUtils {
    private static final Log logger = LogFactory.getLog(TestPropertySourceUtils.class);

    private TestPropertySourceUtils() {
    }

    static MergedTestPropertySources buildMergedTestPropertySources(Class<?> testClass) {
        Class<TestPropertySource> annotationType = TestPropertySource.class;
        MetaAnnotationUtils.AnnotationDescriptor<TestPropertySource> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, annotationType);
        if (descriptor == null) {
            return new MergedTestPropertySources();
        }
        List<TestPropertySourceAttributes> attributesList = TestPropertySourceUtils.resolveTestPropertySourceAttributes(testClass);
        String[] locations = TestPropertySourceUtils.mergeLocations(attributesList);
        String[] properties = TestPropertySourceUtils.mergeProperties(attributesList);
        return new MergedTestPropertySources(locations, properties);
    }

    private static List<TestPropertySourceAttributes> resolveTestPropertySourceAttributes(Class<?> testClass) {
        Assert.notNull(testClass, (String)"Class must not be null");
        ArrayList<TestPropertySourceAttributes> attributesList = new ArrayList<TestPropertySourceAttributes>();
        Class<TestPropertySource> annotationType = TestPropertySource.class;
        MetaAnnotationUtils.AnnotationDescriptor<TestPropertySource> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, annotationType);
        Assert.notNull(descriptor, (String)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType.getName(), testClass.getName()));
        while (descriptor != null) {
            AnnotationAttributes annAttrs = descriptor.getAnnotationAttributes();
            Class<?> rootDeclaringClass = descriptor.getRootDeclaringClass();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Retrieved @TestPropertySource attributes [%s] for declaring class [%s].", annAttrs, rootDeclaringClass.getName()));
            }
            TestPropertySourceAttributes attributes = new TestPropertySourceAttributes(rootDeclaringClass, annAttrs);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Resolved TestPropertySource attributes: " + attributes));
            }
            attributesList.add(attributes);
            descriptor = MetaAnnotationUtils.findAnnotationDescriptor(rootDeclaringClass.getSuperclass(), annotationType);
        }
        return attributesList;
    }

    private static String[] mergeLocations(List<TestPropertySourceAttributes> attributesList) {
        ArrayList<String> locations = new ArrayList<String>();
        for (TestPropertySourceAttributes attrs : attributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Processing locations for TestPropertySource attributes %s", attrs));
            }
            String[] locationsArray = TestContextResourceUtils.convertToClasspathResourcePaths(attrs.getDeclaringClass(), attrs.getLocations());
            locations.addAll(0, Arrays.asList(locationsArray));
            if (attrs.isInheritLocations()) continue;
            break;
        }
        return StringUtils.toStringArray(locations);
    }

    private static String[] mergeProperties(List<TestPropertySourceAttributes> attributesList) {
        ArrayList<String> properties = new ArrayList<String>();
        for (TestPropertySourceAttributes attrs : attributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Processing inlined properties for TestPropertySource attributes %s", attrs));
            }
            properties.addAll(0, Arrays.asList(attrs.getProperties()));
            if (attrs.isInheritProperties()) continue;
            break;
        }
        return StringUtils.toStringArray(properties);
    }
}

