/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.command;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.subethamail.smtp.server.BaseCommand;
import org.subethamail.smtp.server.ConnectionContext;
import org.subethamail.smtp.server.Session;
import org.subethamail.smtp.server.io.CharTerminatedInputStream;
import org.subethamail.smtp.server.io.DeferredFileOutputStream;
import org.subethamail.smtp.server.io.DotUnstuffingInputStream;

public class DataCommand
extends BaseCommand {
    private static final char[] SMTP_TERMINATOR = new char[]{'\r', '\n', '.', '\r', '\n'};

    public DataCommand() {
        super("DATA", "Following text is collected as the message.\nEnd data with <CR><LF>.<CR><LF>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String commandString, ConnectionContext context) throws IOException {
        Session session = context.getSession();
        if (session.getSender() == null) {
            context.sendResponse("503 Error: need MAIL command");
            return;
        }
        if (session.getDeliveries().size() == 0) {
            context.sendResponse("503 Error: need RCPT command");
            return;
        }
        context.sendResponse("354 End data with <CR><LF>.<CR><LF>");
        session.setDataMode(true);
        InputStream stream = context.getConnection().getInput();
        stream = new BufferedInputStream(stream);
        stream = new CharTerminatedInputStream(stream, SMTP_TERMINATOR);
        stream = new DotUnstuffingInputStream(stream);
        if (session.getDeliveries().size() == 1) {
            Session.Delivery delivery = session.getDeliveries().get(0);
            delivery.getListener().deliver(session.getSender(), delivery.getRecipient(), stream);
        } else {
            DeferredFileOutputStream dfos = new DeferredFileOutputStream(context.getServer().getDataDeferredSize());
            try {
                int value;
                while ((value = stream.read()) >= 0) {
                    dfos.write(value);
                }
                for (Session.Delivery delivery : session.getDeliveries()) {
                    delivery.getListener().deliver(session.getSender(), delivery.getRecipient(), dfos.getInputStream());
                }
            }
            finally {
                dfos.close();
            }
        }
        session.reset(true);
        context.sendResponse("250 Ok");
    }
}

