/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.command;

import java.io.IOException;
import org.subethamail.smtp.MessageListener;
import org.subethamail.smtp.server.BaseCommand;
import org.subethamail.smtp.server.ConnectionContext;
import org.subethamail.smtp.server.Session;

public class ReceiptCommand
extends BaseCommand {
    public ReceiptCommand() {
        super("RCPT", "Specifies the recipient. Can be used any number of times.", "TO: <recipient> [ <parameters> ]");
    }

    public void execute(String commandString, ConnectionContext context) throws IOException {
        Session session = context.getSession();
        if (session.getSender() == null) {
            context.sendResponse("503 Error: need MAIL command");
            return;
        }
        if (session.getDeliveries().size() >= context.getServer().getMaxRecipients()) {
            context.sendResponse("452 Error: too many recipients");
            return;
        }
        String args = this.getArgPredicate(commandString);
        if (!args.toUpperCase().startsWith("TO:")) {
            context.sendResponse("501 Syntax: RCPT TO: <address>  Error in parameters: \"" + args + "\"");
            return;
        }
        String recipientAddress = this.extractEmailAddress(args, 3);
        if (this.handleRecipient(recipientAddress, context)) {
            context.sendResponse("250 Ok");
        } else {
            context.sendResponse("553 <" + recipientAddress + "> address unknown.");
        }
    }

    private boolean handleRecipient(String recipientAddress, ConnectionContext context) {
        Session session = context.getSession();
        boolean addedListener = false;
        for (MessageListener listener : context.getServer().getListeners()) {
            if (!listener.accept(session.getSender(), recipientAddress)) continue;
            session.addListener(listener, recipientAddress);
            addedListener = true;
        }
        return addedListener;
    }
}

