/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.subethamail.smtp.MessageListener;
import org.subethamail.smtp.Version;
import org.subethamail.smtp.server.CommandHandler;
import org.subethamail.smtp.server.ConnectionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTPServer
implements Runnable {
    private static Log log = LogFactory.getLog(SMTPServer.class);
    private InetAddress bindAddress = null;
    private int port = 25;
    private String hostName;
    private int backlog = 50;
    private Collection<MessageListener> listeners;
    private CommandHandler commandHandler;
    private ServerSocket serverSocket;
    private boolean go = false;
    private Thread serverThread;
    private Watchdog watchdog;
    private ThreadGroup connectionHanderGroup;
    private int maxConnections = 1000;
    private int connectionTimeout = 60000;
    private int maxRecipients = 1000;
    private int dataDeferredSize = 0x500000;

    public SMTPServer(Collection<MessageListener> listeners) {
        this.listeners = listeners;
        try {
            this.hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            this.hostName = "localhost";
        }
        this.commandHandler = new CommandHandler();
        this.connectionHanderGroup = new ThreadGroup(SMTPServer.class.getName() + " ConnectionHandler Group");
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void start() {
        if (this.serverThread != null) {
            throw new IllegalStateException("SMTPServer already started");
        }
        this.go = true;
        this.serverThread = new Thread((Runnable)this, SMTPServer.class.getName());
        this.serverThread.start();
        this.watchdog = new Watchdog(this);
        this.watchdog.setDaemon(true);
        this.watchdog.start();
    }

    public void stop() {
        this.go = false;
        this.serverThread = null;
        if (this.watchdog != null) {
            this.watchdog.quit();
            this.watchdog = null;
        }
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        this.serverSocket = null;
        try {
            Thread.sleep(600L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected ServerSocket createServerSocket() throws IOException {
        InetSocketAddress isa = this.bindAddress == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.bindAddress, this.port);
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.setReuseAddress(true);
        serverSocket.bind(isa, this.backlog);
        return serverSocket;
    }

    @Override
    public void run() {
        try {
            this.serverSocket = this.createServerSocket();
            if (this.serverSocket == null) {
                throw new Exception("ServerSocket cannot be null!");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        while (this.go) {
            try {
                ConnectionHandler connectionHandler = new ConnectionHandler(this, this.serverSocket.accept());
                connectionHandler.start();
            }
            catch (IOException ioe) {
                if (!this.go) continue;
                log.error((Object)ioe.toString());
            }
        }
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
            log.info((Object)"SMTP Server socket shut down.");
        }
        catch (IOException e) {
            log.error((Object)"Failed to close server socket.", (Throwable)e);
        }
        this.serverSocket = null;
    }

    public String getName() {
        return "SubEthaSMTP";
    }

    public String getNameVersion() {
        return this.getName() + " " + Version.getSpecification();
    }

    public Collection<MessageListener> getListeners() {
        return this.listeners;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    protected ThreadGroup getConnectionGroup() {
        return this.connectionHanderGroup;
    }

    public int getNumberOfConnections() {
        return this.connectionHanderGroup.activeCount();
    }

    public boolean hasTooManyConnections() {
        return this.getNumberOfConnections() >= this.maxConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxRecipients() {
        return this.maxRecipients;
    }

    public void setMaxRecipients(int maxRecipients) {
        this.maxRecipients = maxRecipients;
    }

    public int getDataDeferredSize() {
        return this.dataDeferredSize;
    }

    public void setDataDeferredSize(int dataDeferredSize) {
        this.dataDeferredSize = dataDeferredSize;
    }

    private class Watchdog
    extends Thread {
        private SMTPServer server;
        private Thread[] groupThreads;
        private boolean run;

        public Watchdog(SMTPServer server) {
            super(Watchdog.class.getName());
            this.groupThreads = new Thread[SMTPServer.this.maxConnections];
            this.run = true;
            this.server = server;
            this.setPriority(3);
        }

        public void quit() {
            this.run = false;
        }

        public void run() {
            while (this.run) {
                ThreadGroup connectionGroup = this.server.getConnectionGroup();
                connectionGroup.enumerate(this.groupThreads);
                for (int i = 0; i < connectionGroup.activeCount(); ++i) {
                    long lastActiveTime;
                    ConnectionHandler aThread = (ConnectionHandler)this.groupThreads[i];
                    if (aThread == null || (lastActiveTime = aThread.getLastActiveTime() + (long)this.server.connectionTimeout) >= System.currentTimeMillis()) continue;
                    try {
                        aThread.timeout();
                        continue;
                    }
                    catch (IOException ioe) {
                        log.debug((Object)"Lost connection to client during timeout");
                    }
                }
                try {
                    Watchdog.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

