/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.util.ArrayList;
import java.util.List;
import org.subethamail.smtp.MessageListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session {
    private boolean dataMode = false;
    private boolean hasSeenHelo = false;
    private boolean active = true;
    private String sender = null;
    private List<Delivery> deliveries = new ArrayList<Delivery>();

    public boolean isActive() {
        return this.active;
    }

    public void quit() {
        this.active = false;
    }

    public void addListener(MessageListener messageListener, String recipient) {
        Delivery delivery = new Delivery(messageListener, recipient);
        this.deliveries.add(delivery);
    }

    public List<Delivery> getDeliveries() {
        return this.deliveries;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public boolean hasSeenHelo() {
        return this.hasSeenHelo;
    }

    public void setHasSeenHelo(boolean hasSeenHelo) {
        this.hasSeenHelo = hasSeenHelo;
    }

    public boolean isDataMode() {
        return this.dataMode;
    }

    public void setDataMode(boolean dataMode) {
        this.dataMode = dataMode;
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean hasSeenHelo) {
        this.sender = null;
        this.dataMode = false;
        this.active = true;
        this.hasSeenHelo = hasSeenHelo;
        this.deliveries.clear();
    }

    public class Delivery {
        MessageListener listener;
        String recipient;

        public Delivery(MessageListener listener, String recipient) {
            this.listener = listener;
            this.recipient = recipient;
        }

        public MessageListener getListener() {
            return this.listener;
        }

        public String getRecipient() {
            return this.recipient;
        }
    }
}

