/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.auth;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.auth.LoginFailedException;
import org.subethamail.smtp.auth.UsernamePasswordValidator;
import org.subethamail.smtp.util.Base64;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainAuthenticationHandler
implements AuthenticationHandler {
    private UsernamePasswordValidator helper;

    public PlainAuthenticationHandler(UsernamePasswordValidator helper) {
        this.helper = helper;
    }

    @Override
    public List<String> getAuthenticationMechanisms() {
        ArrayList<String> ret = new ArrayList<String>(1);
        ret.add("PLAIN");
        return ret;
    }

    @Override
    public boolean auth(String clientInput, StringBuffer response) throws RejectException {
        byte[] decodedSecret;
        StringTokenizer stk = new StringTokenizer(clientInput);
        String secret = stk.nextToken();
        if (secret.trim().equalsIgnoreCase("AUTH")) {
            if (!stk.nextToken().trim().equalsIgnoreCase("PLAIN")) {
                response.append("504 AUTH mechanism mismatch.");
                return true;
            }
            if (stk.hasMoreTokens()) {
                secret = stk.nextToken();
            } else {
                response.append("334 Ok");
                return false;
            }
        }
        if ((decodedSecret = Base64.decode(secret)) == null) {
            throw new RejectException();
        }
        int usernameStop = -1;
        for (int i = 1; i < decodedSecret.length && usernameStop < 0; ++i) {
            if (decodedSecret[i] != 0) continue;
            usernameStop = i;
        }
        String username = new String(decodedSecret, 1, usernameStop - 1);
        String password = new String(decodedSecret, usernameStop + 1, decodedSecret.length - usernameStop - 1);
        try {
            this.helper.login(username.toString(), password);
            this.resetState();
        }
        catch (LoginFailedException lfe) {
            this.resetState();
            throw new RejectException();
        }
        return true;
    }

    @Override
    public void resetState() {
    }
}

