/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.auth;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.RejectException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginAuthenticationHandler
implements AuthenticationHandler {
    private List<AuthenticationHandler> plugins = new ArrayList<AuthenticationHandler>();
    private AuthenticationHandler activeHandler;

    @Override
    public List<String> getAuthenticationMechanisms() {
        ArrayList<String> ret = new ArrayList<String>();
        for (AuthenticationHandler plugin : this.plugins) {
            ret.addAll(plugin.getAuthenticationMechanisms());
        }
        return ret;
    }

    @Override
    public boolean auth(String clientInput, StringBuffer response) throws RejectException {
        StringTokenizer stk = new StringTokenizer(clientInput);
        if (stk.nextToken().equalsIgnoreCase("AUTH")) {
            this.resetState();
            this.activateHandler(stk.nextToken().toUpperCase());
        }
        return this.getActiveHandler().auth(clientInput, response);
    }

    @Override
    public void resetState() {
        if (this.getActiveHandler() != null) {
            this.getActiveHandler().resetState();
        }
        this.setActiveHandler(null);
    }

    private void activateHandler(String mechanism) {
        for (AuthenticationHandler plugin : this.plugins) {
            if (!plugin.getAuthenticationMechanisms().contains(mechanism)) continue;
            this.setActiveHandler(plugin);
            return;
        }
    }

    public List<AuthenticationHandler> getPlugins() {
        return this.plugins;
    }

    public void addPlugin(AuthenticationHandler plugin) {
        this.plugins.add(plugin);
    }

    public void setPlugins(List<AuthenticationHandler> plugins) {
        this.plugins = plugins;
    }

    public AuthenticationHandler getActiveHandler() {
        return this.activeHandler;
    }

    public void setActiveHandler(AuthenticationHandler activeHandler) {
        this.activeHandler = activeHandler;
    }
}

