/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.subethamail.smtp.server.Command;
import org.subethamail.smtp.server.CommandException;
import org.subethamail.smtp.server.ConnectionContext;
import org.subethamail.smtp.server.HelpMessage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseCommand
implements Command {
    private String name;
    private static Map<String, HelpMessage> helpMessageMap = new HashMap<String, HelpMessage>();
    private static Log log;
    static /* synthetic */ Class class$org$subethamail$smtp$server$BaseCommand;

    public BaseCommand(String name, String help) {
        this.name = name;
        this.setHelp(new HelpMessage(name, help));
    }

    public BaseCommand(String name, String help, String argumentDescription) {
        this.name = name;
        this.setHelp(new HelpMessage(name, help, argumentDescription));
    }

    @Override
    public abstract void execute(String var1, ConnectionContext var2) throws IOException;

    public void setHelp(HelpMessage helpMessage) {
        helpMessageMap.put(helpMessage.getName().toUpperCase(), helpMessage);
    }

    @Override
    public HelpMessage getHelp(String commandName) throws CommandException {
        HelpMessage msg = helpMessageMap.get(commandName.toUpperCase());
        if (msg == null) {
            throw new CommandException();
        }
        return msg;
    }

    public Map<String, HelpMessage> getHelp() {
        return helpMessageMap;
    }

    protected String getArgPredicate(String commandString) {
        if (commandString == null || commandString.length() < 4) {
            return "";
        }
        return commandString.substring(4).trim();
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected boolean isValidEmailAddress(String address) {
        if (address.length() == 0) {
            return true;
        }
        boolean result = false;
        try {
            InternetAddress[] ia = InternetAddress.parse((String)address, (boolean)true);
            result = ia.length != 0;
        }
        catch (AddressException ae) {
            result = false;
        }
        return result;
    }

    protected static String getTokenizedString(Collection<String> items, String delim) {
        StringBuffer ret = new StringBuffer();
        Iterator<String> it = items.iterator();
        while (it.hasNext()) {
            ret.append(it.next());
            if (!it.hasNext()) continue;
            ret.append(delim);
        }
        return ret.toString();
    }

    protected String[] getArgs(String commandString) {
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(commandString);
        while (stringTokenizer.hasMoreTokens()) {
            strings.add(stringTokenizer.nextToken());
        }
        return strings.toArray(new String[strings.size()]);
    }

    protected String extractEmailAddress(String args, int subcommandOffset) {
        String address = args.substring(subcommandOffset).trim();
        if (address.indexOf(60) == 0) {
            address = address.substring(1, address.indexOf(62));
        }
        return address;
    }

    static {
        Class<?> clazz = class$org$subethamail$smtp$server$BaseCommand;
        if (clazz == null) {
            clazz = class$org$subethamail$smtp$server$BaseCommand = new BaseCommand[0].getClass().getComponentType();
        }
        log = LogFactory.getLog((Class)clazz);
    }
}

