/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.server.ConnectionContext;
import org.subethamail.smtp.server.SMTPServer;
import org.subethamail.smtp.server.Session;
import org.subethamail.smtp.server.io.CRLFTerminatedReader;
import org.subethamail.smtp.server.io.LastActiveInputStream;

public class ConnectionHandler
extends Thread
implements ConnectionContext,
MessageContext {
    private static Log log;
    private SMTPServer server;
    private Session session;
    private InputStream input;
    private OutputStream output;
    private CRLFTerminatedReader reader;
    private PrintWriter writer;
    private Socket socket;
    private long startTime;
    private long lastActiveTime;
    static /* synthetic */ Class class$org$subethamail$smtp$server$ConnectionHandler;

    public ConnectionHandler(SMTPServer server, Socket socket) throws IOException {
        ThreadGroup threadGroup = server.getConnectionGroup();
        Class<?> clazz = class$org$subethamail$smtp$server$ConnectionHandler;
        if (clazz == null) {
            clazz = class$org$subethamail$smtp$server$ConnectionHandler = new ConnectionHandler[0].getClass().getComponentType();
        }
        super(threadGroup, clazz.getName());
        this.server = server;
        this.setSocket(socket);
        this.lastActiveTime = this.startTime = System.currentTimeMillis();
    }

    public Session getSession() {
        return this.session;
    }

    public ConnectionHandler getConnection() {
        return this;
    }

    public SMTPServer getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout() throws IOException {
        try {
            this.sendResponse("421 Timeout waiting for data from client.");
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("SMTP connection count: " + this.server.getNumberOfConnections()));
        }
        this.session = new Session(this.server.getMessageHandlerFactory().create(this));
        try {
            if (this.server.hasTooManyConnections()) {
                log.debug((Object)"SMTP Too many connections!");
                this.sendResponse("554 Transaction failed. Too many connections.");
                return;
            }
            this.sendResponse("220 " + this.server.getHostName() + " ESMTP " + this.server.getName());
            while (this.session.isActive()) {
                try {
                    String line = this.reader.readLine();
                    if (line == null) {
                        log.debug((Object)"no more lines from client");
                        break;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Client: " + line));
                    }
                    this.server.getCommandHandler().handleCommand(this, line);
                    this.lastActiveTime = System.currentTimeMillis();
                }
                catch (CRLFTerminatedReader.TerminationException te) {
                    String msg = "501 Syntax error at character position " + te.position() + ". CR and LF must be CRLF paired.  See RFC 2821 #2.7.1.";
                    log.debug((Object)msg);
                    this.sendResponse(msg);
                    break;
                }
                catch (CRLFTerminatedReader.MaxLineLengthException mlle) {
                    String msg = "501 " + mlle.getMessage();
                    log.debug((Object)msg);
                    this.sendResponse(msg);
                    break;
                }
            }
        }
        catch (IOException e1) {
            try {
                this.sendResponse("450 Problem attempting to execute commands. Please try again later.");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)e1);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection() {
        try {
            try {
                this.writer.close();
                this.input.close();
            }
            finally {
                this.closeSocket();
            }
        }
        catch (IOException e) {
            log.debug((Object)e);
        }
    }

    public void setSocket(Socket socket) throws IOException {
        this.socket = socket;
        this.input = new LastActiveInputStream(this.socket.getInputStream(), this);
        this.output = this.socket.getOutputStream();
        this.reader = new CRLFTerminatedReader(this.input);
        this.writer = new PrintWriter(this.output);
    }

    public Socket getSocket() {
        return this.socket;
    }

    private void closeSocket() throws IOException {
        if (this.socket != null && this.socket.isBound() && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    public InputStream getInput() {
        return this.input;
    }

    public OutputStream getOutput() {
        return this.output;
    }

    public void sendResponse(String response) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Server: " + response));
        }
        this.writer.print(response + "\r\n");
        this.writer.flush();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastActiveTime() {
        return this.lastActiveTime;
    }

    public void refreshLastActiveTime() {
        this.lastActiveTime = System.currentTimeMillis();
    }

    public SocketAddress getRemoteAddress() {
        return this.socket.getRemoteSocketAddress();
    }

    public SMTPServer getSMTPServer() {
        return this.server;
    }

    static {
        Class<?> clazz = class$org$subethamail$smtp$server$ConnectionHandler;
        if (clazz == null) {
            clazz = class$org$subethamail$smtp$server$ConnectionHandler = new ConnectionHandler[0].getClass().getComponentType();
        }
        log = LogFactory.getLog((Class)clazz);
    }
}

