/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.MessageListener;
import org.subethamail.smtp.Version;
import org.subethamail.smtp.server.CommandHandler;
import org.subethamail.smtp.server.ConnectionHandler;
import org.subethamail.smtp.server.MessageListenerAdapter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMTPServer
implements Runnable {
    private static Log log;
    private InetAddress bindAddress = null;
    private int port = 25;
    private String hostName;
    private int backlog = 50;
    private MessageHandlerFactory messageHandlerFactory;
    private CommandHandler commandHandler;
    private ServerSocket serverSocket;
    private boolean go = false;
    private Thread serverThread;
    private Watchdog watchdog;
    private ThreadGroup connectionHanderGroup;
    private int maxConnections = 1000;
    private int connectionTimeout = 60000;
    private int maxRecipients = 1000;
    static /* synthetic */ Class class$org$subethamail$smtp$server$SMTPServer;

    public SMTPServer(MessageHandlerFactory handlerFactory) {
        this.messageHandlerFactory = handlerFactory;
        try {
            this.hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            this.hostName = "localhost";
        }
        this.commandHandler = new CommandHandler();
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz = class$org$subethamail$smtp$server$SMTPServer;
        if (clazz == null) {
            clazz = class$org$subethamail$smtp$server$SMTPServer = new SMTPServer[0].getClass().getComponentType();
        }
        this.connectionHanderGroup = new ThreadGroup(stringBuffer.append(clazz.getName()).append(" ConnectionHandler Group").toString());
    }

    public SMTPServer(Collection<MessageListener> listeners) {
        this(new MessageListenerAdapter(listeners));
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isRunning() {
        return this.go;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public synchronized void start() {
        if (this.serverThread != null) {
            throw new IllegalStateException("SMTPServer already started");
        }
        try {
            this.serverSocket = this.createServerSocket();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.go = true;
        Class<?> clazz = class$org$subethamail$smtp$server$SMTPServer;
        if (clazz == null) {
            clazz = class$org$subethamail$smtp$server$SMTPServer = new SMTPServer[0].getClass().getComponentType();
        }
        this.serverThread = new Thread((Runnable)this, clazz.getName());
        this.serverThread.start();
        this.watchdog = new Watchdog(this);
        this.watchdog.setDaemon(true);
        this.watchdog.start();
    }

    public synchronized void stop() {
        this.go = false;
        this.serverThread = null;
        if (this.watchdog != null) {
            this.watchdog.quit();
            this.watchdog = null;
        }
        this.shutDownOpenConnections();
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void shutDownOpenConnections() {
        Thread[] groupThreads = new Thread[this.maxConnections];
        ThreadGroup connectionGroup = this.getConnectionGroup();
        connectionGroup.enumerate(groupThreads);
        for (int i = 0; i < connectionGroup.activeCount(); ++i) {
            Socket socket;
            ConnectionHandler handler = (ConnectionHandler)groupThreads[i];
            if (handler == null || (socket = handler.getSocket()) == null || socket.isClosed()) continue;
            try {
                socket.close();
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    protected ServerSocket createServerSocket() throws IOException {
        InetSocketAddress isa = this.bindAddress == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.bindAddress, this.port);
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.setReuseAddress(true);
        serverSocket.bind(isa, this.backlog);
        return serverSocket;
    }

    @Override
    public void run() {
        while (this.go) {
            try {
                ConnectionHandler connectionHandler = new ConnectionHandler(this, this.serverSocket.accept());
                connectionHandler.start();
            }
            catch (IOException ioe) {
                if (!this.go) continue;
                log.error((Object)"Error accepting connections", (Throwable)ioe);
            }
        }
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
            log.info((Object)"SMTP Server socket shut down.");
        }
        catch (IOException e) {
            log.error((Object)"Failed to close server socket.", (Throwable)e);
        }
        this.serverSocket = null;
    }

    public String getName() {
        return "SubEthaSMTP";
    }

    public String getNameVersion() {
        return new StringBuffer().append(this.getName()).append(" ").append(Version.getSpecification()).toString();
    }

    public MessageHandlerFactory getMessageHandlerFactory() {
        return this.messageHandlerFactory;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    protected ThreadGroup getConnectionGroup() {
        return this.connectionHanderGroup;
    }

    public int getNumberOfConnections() {
        return this.connectionHanderGroup.activeCount();
    }

    public boolean hasTooManyConnections() {
        return this.getNumberOfConnections() >= this.maxConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxRecipients() {
        return this.maxRecipients;
    }

    public void setMaxRecipients(int maxRecipients) {
        this.maxRecipients = maxRecipients;
    }

    static {
        Class<?> clazz = class$org$subethamail$smtp$server$SMTPServer;
        if (clazz == null) {
            clazz = class$org$subethamail$smtp$server$SMTPServer = new SMTPServer[0].getClass().getComponentType();
        }
        log = LogFactory.getLog((Class)clazz);
    }

    private class Watchdog
    extends Thread {
        private SMTPServer server;
        private boolean run;
        static /* synthetic */ Class class$org$subethamail$smtp$server$SMTPServer$Watchdog;

        public Watchdog(SMTPServer server) {
            Class<?> clazz = class$org$subethamail$smtp$server$SMTPServer$Watchdog;
            if (clazz == null) {
                clazz = class$org$subethamail$smtp$server$SMTPServer$Watchdog = new Watchdog[0].getClass().getComponentType();
            }
            super(clazz.getName());
            this.run = true;
            this.server = server;
            this.setPriority(3);
        }

        public void quit() {
            this.run = false;
        }

        public void run() {
            while (this.run) {
                Thread[] groupThreads = new Thread[SMTPServer.this.maxConnections];
                ThreadGroup connectionGroup = this.server.getConnectionGroup();
                connectionGroup.enumerate(groupThreads);
                for (int i = 0; i < connectionGroup.activeCount(); ++i) {
                    long lastActiveTime;
                    ConnectionHandler aThread = (ConnectionHandler)groupThreads[i];
                    if (aThread == null || (lastActiveTime = aThread.getLastActiveTime() + (long)this.server.connectionTimeout) >= System.currentTimeMillis()) continue;
                    try {
                        aThread.timeout();
                        continue;
                    }
                    catch (IOException ioe) {
                        log.debug((Object)"Lost connection to client during timeout");
                    }
                }
                try {
                    Watchdog.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

