/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.auth;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.auth.Credential;
import org.subethamail.smtp.auth.LoginFailedException;
import org.subethamail.smtp.auth.UsernamePasswordValidator;
import org.subethamail.smtp.server.ConnectionContext;
import org.subethamail.smtp.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoginAuthenticationHandler
implements AuthenticationHandler {
    private String username;
    private String password;
    private UsernamePasswordValidator helper;
    private static List<String> AUTH_MECH;

    public LoginAuthenticationHandler(UsernamePasswordValidator helper) {
        this.helper = helper;
        AUTH_MECH = new ArrayList<String>(1);
        AUTH_MECH.add("LOGIN");
    }

    @Override
    public List<String> getAuthenticationMechanisms() {
        return AUTH_MECH;
    }

    @Override
    public boolean auth(String clientInput, StringBuilder response, ConnectionContext ctx) throws RejectException {
        StringTokenizer stk = new StringTokenizer(clientInput);
        String token = stk.nextToken();
        if (token.trim().equalsIgnoreCase("AUTH")) {
            if (!stk.nextToken().trim().equalsIgnoreCase("LOGIN")) {
                response.append("504 AUTH mechanism mismatch.");
                return true;
            }
            if (stk.hasMoreTokens()) {
                response.append("535 Initial response not allowed in AUTH LOGIN.");
                return true;
            }
            response.append("334 ").append(Base64.encodeToString("Username:".getBytes(), false));
            return false;
        }
        if (this.username == null) {
            byte[] decoded = Base64.decode(clientInput);
            if (decoded == null) {
                throw new RejectException();
            }
            this.username = new String(decoded);
            response.append("334 ").append(Base64.encodeToString("Password:".getBytes(), false));
            return false;
        }
        byte[] decoded = Base64.decode(clientInput);
        if (decoded == null) {
            throw new RejectException();
        }
        this.password = new String(decoded);
        try {
            this.helper.login(this.username, this.password);
            this.resetState();
        }
        catch (LoginFailedException lfe) {
            this.resetState();
            throw new RejectException();
        }
        ctx.setCredential(new Credential(this.username));
        return true;
    }

    @Override
    public void resetState() {
        this.username = null;
        this.password = null;
    }
}

