/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.auth;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.auth.LoginFailedException;
import org.subethamail.smtp.auth.UsernamePasswordValidator;
import org.subethamail.smtp.util.Base64;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainAuthenticationHandlerFactory
implements AuthenticationHandlerFactory {
    static List<String> MECHANISMS = new ArrayList<String>(1);
    private UsernamePasswordValidator helper;

    public PlainAuthenticationHandlerFactory(UsernamePasswordValidator helper) {
        this.helper = helper;
    }

    @Override
    public List<String> getAuthenticationMechanisms() {
        return MECHANISMS;
    }

    @Override
    public AuthenticationHandler create() {
        return new Handler();
    }

    static {
        MECHANISMS.add("PLAIN");
    }

    class Handler
    implements AuthenticationHandler {
        private String username;
        private String password;

        Handler() {
        }

        public String auth(String clientInput) throws RejectException {
            byte[] decodedSecret;
            StringTokenizer stk = new StringTokenizer(clientInput);
            String secret = stk.nextToken();
            if (secret.trim().equalsIgnoreCase("AUTH")) {
                if (!stk.nextToken().trim().equalsIgnoreCase("PLAIN")) {
                    throw new RejectException(504, "AUTH mechanism mismatch");
                }
                if (stk.hasMoreTokens()) {
                    secret = stk.nextToken();
                } else {
                    return "334 Ok";
                }
            }
            if ((decodedSecret = Base64.decode(secret)) == null) {
                throw new RejectException();
            }
            int usernameStop = -1;
            for (int i = 1; i < decodedSecret.length && usernameStop < 0; ++i) {
                if (decodedSecret[i] != 0) continue;
                usernameStop = i;
            }
            this.username = new String(decodedSecret, 1, usernameStop - 1);
            this.password = new String(decodedSecret, usernameStop + 1, decodedSecret.length - usernameStop - 1);
            try {
                PlainAuthenticationHandlerFactory.this.helper.login(this.username.toString(), this.password);
            }
            catch (LoginFailedException lfe) {
                throw new RejectException();
            }
            return null;
        }

        public Object getIdentity() {
            return this.username;
        }
    }
}

