/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.MessageHandlerFactory;
import org.subethamail.smtp.Version;
import org.subethamail.smtp.server.CommandHandler;
import org.subethamail.smtp.server.Session;

public class SMTPServer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SMTPServer.class);
    private static final String UNKNOWN_HOSTNAME = "localhost";
    private InetAddress bindAddress = null;
    private int port = 25;
    private String hostName;
    private int backlog = 50;
    private MessageHandlerFactory messageHandlerFactory;
    private AuthenticationHandlerFactory authenticationHandlerFactory;
    private CommandHandler commandHandler;
    private ServerSocket serverSocket;
    private boolean shuttingDown;
    private Thread serverThread;
    private ThreadGroup sessionGroup;
    private boolean hideTLS = false;
    private boolean requireTLS;
    private int maxConnections = 1000;
    private int connectionTimeout = 60000;
    private int maxRecipients = 1000;
    private int maxMessageSize = 0;

    public SMTPServer(MessageHandlerFactory handlerFactory) {
        this(handlerFactory, null);
    }

    public SMTPServer(MessageHandlerFactory msgHandlerFact, AuthenticationHandlerFactory authHandlerFact) {
        this.messageHandlerFactory = msgHandlerFact;
        this.authenticationHandlerFactory = authHandlerFact;
        try {
            this.hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            this.hostName = UNKNOWN_HOSTNAME;
        }
        this.commandHandler = new CommandHandler();
        this.sessionGroup = new ThreadGroup(SMTPServer.class.getName() + " Session Group");
    }

    public String getHostName() {
        if (this.hostName == null) {
            return UNKNOWN_HOSTNAME;
        }
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public InetAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(InetAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isRunning() {
        return this.serverThread != null;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public synchronized void start() {
        if (log.isInfoEnabled()) {
            log.info("SMTP server {} starting", (Object)this.getDisplayableLocalSocketAddress());
        }
        if (this.serverThread != null) {
            throw new IllegalStateException("SMTPServer already started");
        }
        try {
            this.serverSocket = this.createServerSocket();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.serverThread = new Thread((Runnable)this, SMTPServer.class.getName());
        this.shuttingDown = false;
        this.serverThread.start();
    }

    public synchronized void stop() {
        if (log.isInfoEnabled()) {
            log.info("SMTP server {} stopping", (Object)this.getDisplayableLocalSocketAddress());
        }
        this.stopServerThread();
        this.stopAllSessions();
    }

    protected void stopAllSessions() {
        Thread[] groupThreads = new Thread[this.getSessionGroup().activeCount()];
        this.getSessionGroup().enumerate(groupThreads);
        for (Thread thread : groupThreads) {
            if (!(thread instanceof Session)) continue;
            Session handler = (Session)thread;
            handler.quit();
        }
    }

    protected ServerSocket createServerSocket() throws IOException {
        InetSocketAddress isa = this.bindAddress == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.bindAddress, this.port);
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.setReuseAddress(true);
        serverSocket.bind(isa, this.backlog);
        return serverSocket;
    }

    protected void closeServerSocket() {
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
            log.debug("SMTP Server socket shut down");
        }
        catch (IOException e) {
            log.error("Failed to close server socket.", (Throwable)e);
        }
        this.serverSocket = null;
    }

    public SSLSocket createSSLSocket(Socket socket) throws IOException {
        SSLSocketFactory sf = (SSLSocketFactory)SSLSocketFactory.getDefault();
        InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
        SSLSocket s = (SSLSocket)sf.createSocket(socket, remoteAddress.getHostName(), socket.getPort(), true);
        s.setUseClientMode(false);
        s.setEnabledCipherSuites(s.getSupportedCipherSuites());
        return s;
    }

    protected void stopServerThread() {
        this.shuttingDown = true;
        this.closeServerSocket();
        this.serverThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (log.isInfoEnabled()) {
            MDC.put((String)"smtpServerLocalSocketAddress", (String)this.getDisplayableLocalSocketAddress());
            log.info("SMTP server {} started", (Object)this.getDisplayableLocalSocketAddress());
        }
        while (!this.shuttingDown) {
            ServerSocket server;
            SMTPServer sMTPServer = this;
            synchronized (sMTPServer) {
                server = this.serverSocket;
            }
            if (server == null) continue;
            try {
                Session sess = new Session(this, server.accept());
                sess.start();
            }
            catch (IOException ioe) {
                if (this.shuttingDown) continue;
                log.error("Error accepting connections", (Throwable)ioe);
            }
        }
        this.closeServerSocket();
        this.serverSocket = null;
        this.serverThread = null;
        if (log.isInfoEnabled()) {
            log.info("SMTP server {} stopped", (Object)this.getDisplayableLocalSocketAddress());
            MDC.remove((String)"smtpServerLocalSocketAddress");
        }
    }

    public String getName() {
        return "SubEthaSMTP";
    }

    public String getNameVersion() {
        return this.getName() + " " + Version.getSpecification();
    }

    private String getDisplayableLocalSocketAddress() {
        return (this.bindAddress == null ? "*" : this.bindAddress) + ":" + this.port;
    }

    public MessageHandlerFactory getMessageHandlerFactory() {
        return this.messageHandlerFactory;
    }

    public void setMessageHandlerFactory(MessageHandlerFactory fact) {
        this.messageHandlerFactory = fact;
    }

    public AuthenticationHandlerFactory getAuthenticationHandlerFactory() {
        return this.authenticationHandlerFactory;
    }

    public void setAuthenticationHandlerFactory(AuthenticationHandlerFactory fact) {
        this.authenticationHandlerFactory = fact;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    protected ThreadGroup getSessionGroup() {
        return this.sessionGroup;
    }

    public int getNumberOfConnections() {
        return this.sessionGroup.activeCount();
    }

    public boolean hasTooManyConnections() {
        if (this.maxConnections < 0) {
            return false;
        }
        return this.getNumberOfConnections() >= this.maxConnections;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        if (this.isRunning()) {
            throw new RuntimeException("Server is already running. It isn't possible to set the maxConnections. Please stop the server first.");
        }
        this.maxConnections = maxConnections;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getMaxRecipients() {
        return this.maxRecipients;
    }

    public void setMaxRecipients(int maxRecipients) {
        this.maxRecipients = maxRecipients;
    }

    public boolean getHideTLS() {
        return this.hideTLS;
    }

    public void setHideTLS(boolean value) {
        this.hideTLS = value;
    }

    public boolean getRequireTLS() {
        return this.requireTLS;
    }

    public void setRequireTLS(boolean requireTLS) {
        this.requireTLS = requireTLS;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }
}

