/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.wiser;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.subethamail.smtp.TooMuchDataException;
import org.subethamail.smtp.helper.SimpleMessageListener;
import org.subethamail.smtp.helper.SimpleMessageListenerAdapter;
import org.subethamail.smtp.server.SMTPServer;
import org.subethamail.wiser.WiserMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wiser
implements SimpleMessageListener {
    private static final Logger log = LoggerFactory.getLogger(Wiser.class);
    SMTPServer server;
    List<WiserMessage> messages = Collections.synchronizedList(new ArrayList());

    public Wiser() {
        this.server = new SMTPServer(new SimpleMessageListenerAdapter(this));
    }

    public Wiser(int port) {
        this();
        this.setPort(port);
    }

    public void setPort(int port) {
        this.server.setPort(port);
    }

    public void setHostname(String hostname) {
        this.server.setHostName(hostname);
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.server.stop();
    }

    public static void main(String[] args) throws Exception {
        Wiser wiser = new Wiser();
        wiser.start();
    }

    @Override
    public boolean accept(String from, String recipient) {
        if (log.isDebugEnabled()) {
            log.debug("Accepting mail from " + from + " to " + recipient);
        }
        return true;
    }

    @Override
    public void deliver(String from, String recipient, InputStream data) throws TooMuchDataException, IOException {
        int current;
        if (log.isDebugEnabled()) {
            log.debug("Delivering mail from " + from + " to " + recipient);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        data = new BufferedInputStream(data);
        while ((current = data.read()) >= 0) {
            out.write(current);
        }
        byte[] bytes = out.toByteArray();
        if (log.isDebugEnabled()) {
            log.debug("Creating message from data with " + bytes.length + " bytes");
        }
        this.messages.add(new WiserMessage(this, from, recipient, bytes));
    }

    protected Session getSession() {
        return Session.getDefaultInstance((Properties)new Properties());
    }

    public List<WiserMessage> getMessages() {
        return this.messages;
    }

    public SMTPServer getServer() {
        return this.server;
    }

    public void dumpMessages(PrintStream out) throws MessagingException {
        out.println("----- Start printing messages -----");
        for (WiserMessage wmsg : this.getMessages()) {
            wmsg.dumpMessage(out);
        }
        out.println("----- End printing messages -----");
    }
}

