/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.command;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.subethamail.smtp.DropConnectionException;
import org.subethamail.smtp.RejectException;
import org.subethamail.smtp.io.CharTerminatedInputStream;
import org.subethamail.smtp.io.DotUnstuffingInputStream;
import org.subethamail.smtp.io.ReceivedHeaderStream;
import org.subethamail.smtp.server.BaseCommand;
import org.subethamail.smtp.server.Session;

public class DataCommand
extends BaseCommand {
    private static final char[] SMTP_TERMINATOR = new char[]{'\r', '\n', '.', '\r', '\n'};
    private static final int BUFFER_SIZE = 32768;

    public DataCommand() {
        super("DATA", "Following text is collected as the message.\nEnd data with <CR><LF>.<CR><LF>");
    }

    public void execute(String commandString, Session sess) throws IOException {
        if (!sess.getHasMailFrom()) {
            sess.sendResponse("503 Error: need MAIL command");
            return;
        }
        if (sess.getRecipientCount() == 0) {
            sess.sendResponse("503 Error: need RCPT command");
            return;
        }
        sess.sendResponse("354 End data with <CR><LF>.<CR><LF>");
        InputStream stream = sess.getRawInput();
        stream = new BufferedInputStream(stream, 32768);
        stream = new CharTerminatedInputStream(stream, SMTP_TERMINATOR);
        stream = new DotUnstuffingInputStream(stream);
        stream = new ReceivedHeaderStream(stream, sess.getHelo(), sess.getRemoteAddress().getAddress(), sess.getServer().getHostName());
        try {
            sess.getMessageHandler().data(stream);
            while (stream.available() > 0) {
                stream.read();
            }
            sess.sendResponse("250 Ok");
        }
        catch (DropConnectionException ex) {
            throw ex;
        }
        catch (RejectException ex) {
            sess.sendResponse(ex.getErrorResponse());
        }
        sess.resetMessageState();
    }
}

