/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.bots;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.telegram.telegrambots.ApiContext;
import org.telegram.telegrambots.bots.DefaultAbsSender;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.generics.LongPollingBot;

public abstract class TelegramLongPollingBot
extends DefaultAbsSender
implements LongPollingBot {
    public TelegramLongPollingBot() {
        this((DefaultBotOptions)ApiContext.getInstance(DefaultBotOptions.class));
    }

    public TelegramLongPollingBot(DefaultBotOptions options) {
        super(options);
    }

    public void clearWebhook() throws TelegramApiRequestException {
        try (CloseableHttpClient httpclient = HttpClientBuilder.create().setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).build();){
            String url = "https://api.telegram.org/bot" + this.getBotToken() + "/" + "setwebhook";
            HttpGet httpGet = new HttpGet(url);
            httpGet.setConfig(this.getOptions().getRequestConfig());
            try (CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
                HttpEntity ht = response.getEntity();
                BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                String responseContent = EntityUtils.toString((HttpEntity)buf, (Charset)StandardCharsets.UTF_8);
                JSONObject jsonObject = new JSONObject(responseContent);
                if (!jsonObject.getBoolean("ok")) {
                    throw new TelegramApiRequestException("Error removing old webhook", jsonObject);
                }
            }
        }
        catch (JSONException e) {
            throw new TelegramApiRequestException("Error deserializing setWebhook method response", (Throwable)e);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Error executing setWebook method", (Throwable)e);
        }
    }
}

