/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.updatesreceivers;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.telegram.telegrambots.api.methods.updates.GetUpdates;
import org.telegram.telegrambots.api.objects.Update;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.generics.BotOptions;
import org.telegram.telegrambots.generics.BotSession;
import org.telegram.telegrambots.generics.LongPollingBot;
import org.telegram.telegrambots.generics.UpdatesHandler;
import org.telegram.telegrambots.generics.UpdatesReader;
import org.telegram.telegrambots.logging.BotLogger;
import org.telegram.telegrambots.updatesreceivers.ExponentialBackOff;

public class DefaultBotSession
implements BotSession {
    private static final String LOGTAG = "BOTSESSION";
    private volatile boolean running = false;
    private final ConcurrentLinkedDeque<Update> receivedUpdates = new ConcurrentLinkedDeque();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private ReaderThread readerThread;
    private HandlerThread handlerThread;
    private LongPollingBot callback;
    private String token;
    private int lastReceivedUpdate = 0;
    private DefaultBotOptions options;

    @Inject
    public DefaultBotSession() {
    }

    public synchronized void start() {
        if (this.running) {
            throw new IllegalStateException("Session already running");
        }
        this.running = true;
        this.lastReceivedUpdate = 0;
        this.readerThread = new ReaderThread();
        this.readerThread.setName(this.callback.getBotUsername() + " Telegram Connection");
        this.readerThread.start();
        this.handlerThread = new HandlerThread();
        this.handlerThread.setName(this.callback.getBotUsername() + " Telegram Executor");
        this.handlerThread.start();
    }

    public synchronized void stop() {
        if (!this.running) {
            throw new IllegalStateException("Session already stopped");
        }
        this.running = false;
        if (this.readerThread != null) {
            this.readerThread.interrupt();
        }
        if (this.handlerThread != null) {
            this.handlerThread.interrupt();
        }
        if (this.callback != null) {
            this.callback.onClosing();
        }
    }

    public void setOptions(BotOptions options) {
        if (this.options != null) {
            throw new InvalidParameterException("BotOptions has already been set");
        }
        this.options = (DefaultBotOptions)options;
    }

    public void setToken(String token) {
        if (this.token != null) {
            throw new InvalidParameterException("Token has already been set");
        }
        this.token = token;
    }

    public void setCallback(LongPollingBot callback) {
        if (this.callback != null) {
            throw new InvalidParameterException("Callback has already been set");
        }
        this.callback = callback;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private class HandlerThread
    extends Thread
    implements UpdatesHandler {
        private HandlerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setPriority(1);
            while (DefaultBotSession.this.running) {
                try {
                    Update update = (Update)DefaultBotSession.this.receivedUpdates.pollLast();
                    if (update == null) {
                        ConcurrentLinkedDeque concurrentLinkedDeque = DefaultBotSession.this.receivedUpdates;
                        synchronized (concurrentLinkedDeque) {
                            DefaultBotSession.this.receivedUpdates.wait();
                            update = (Update)DefaultBotSession.this.receivedUpdates.pollLast();
                            if (update == null) {
                                continue;
                            }
                        }
                    }
                    DefaultBotSession.this.callback.onUpdateReceived(update);
                }
                catch (InterruptedException e) {
                    BotLogger.debug((String)DefaultBotSession.LOGTAG, (Throwable)e);
                }
                catch (Exception e) {
                    BotLogger.severe((String)DefaultBotSession.LOGTAG, (Throwable)e);
                }
            }
            BotLogger.debug((String)DefaultBotSession.LOGTAG, (String)"Handler thread has being closed");
        }
    }

    private class ReaderThread
    extends Thread
    implements UpdatesReader {
        private CloseableHttpClient httpclient;
        private ExponentialBackOff exponentialBackOff;
        private RequestConfig requestConfig;

        private ReaderThread() {
        }

        @Override
        public synchronized void start() {
            this.httpclient = HttpClientBuilder.create().setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setConnectionTimeToLive(70L, TimeUnit.SECONDS).setMaxConnTotal(100).build();
            this.requestConfig = DefaultBotSession.this.options.getRequestConfig();
            this.exponentialBackOff = DefaultBotSession.this.options.getExponentialBackOff();
            if (this.exponentialBackOff == null) {
                this.exponentialBackOff = new ExponentialBackOff();
            }
            if (this.requestConfig == null) {
                this.requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.custom().build()).setSocketTimeout(75000).setConnectTimeout(75000).setConnectionRequestTimeout(75000).build();
            }
            super.start();
        }

        @Override
        public void interrupt() {
            if (this.httpclient != null) {
                try {
                    this.httpclient.close();
                }
                catch (IOException e) {
                    BotLogger.warn((String)DefaultBotSession.LOGTAG, (Throwable)e);
                }
            }
            super.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.setPriority(1);
            while (DefaultBotSession.this.running) {
                Object url;
                try {
                    GetUpdates request = new GetUpdates().setLimit(Integer.valueOf(100)).setTimeout(Integer.valueOf(50)).setOffset(Integer.valueOf(DefaultBotSession.this.lastReceivedUpdate + 1));
                    if (DefaultBotSession.this.options.getAllowedUpdates() != null) {
                        request.setAllowedUpdates(DefaultBotSession.this.options.getAllowedUpdates());
                    }
                    url = "https://api.telegram.org/bot" + DefaultBotSession.this.token + "/" + "getupdates";
                    HttpPost httpPost = new HttpPost((String)url);
                    httpPost.addHeader("charset", StandardCharsets.UTF_8.name());
                    httpPost.setConfig(this.requestConfig);
                    httpPost.setEntity((HttpEntity)new StringEntity(DefaultBotSession.this.objectMapper.writeValueAsString((Object)request), ContentType.APPLICATION_JSON));
                    try {
                        CloseableHttpResponse response = this.httpclient.execute((HttpUriRequest)httpPost);
                        Throwable throwable = null;
                        try {
                            HttpEntity ht = response.getEntity();
                            BufferedHttpEntity buf = new BufferedHttpEntity(ht);
                            String responseContent = EntityUtils.toString((HttpEntity)buf, (Charset)StandardCharsets.UTF_8);
                            if (response.getStatusLine().getStatusCode() >= 500) {
                                BotLogger.warn((String)DefaultBotSession.LOGTAG, (String)responseContent);
                                ReaderThread readerThread = this;
                                synchronized (readerThread) {
                                    this.wait(500L);
                                    continue;
                                }
                            }
                            try {
                                Object object;
                                ArrayList updates = request.deserializeResponse(responseContent);
                                this.exponentialBackOff.reset();
                                if (updates.isEmpty()) {
                                    object = this;
                                    synchronized (object) {
                                        this.wait(500L);
                                        continue;
                                    }
                                }
                                updates.removeIf(x -> x.getUpdateId() < DefaultBotSession.this.lastReceivedUpdate);
                                DefaultBotSession.this.lastReceivedUpdate = updates.parallelStream().map(Update::getUpdateId).max(Integer::compareTo).orElse(0);
                                DefaultBotSession.this.receivedUpdates.addAll(updates);
                                object = DefaultBotSession.this.receivedUpdates;
                                synchronized (object) {
                                    DefaultBotSession.this.receivedUpdates.notifyAll();
                                }
                            }
                            catch (JSONException e) {
                                BotLogger.severe((String)responseContent, (String)DefaultBotSession.LOGTAG, (Throwable)e);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (response == null) continue;
                            if (throwable != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            response.close();
                        }
                    }
                    catch (InvalidObjectException | TelegramApiRequestException e) {
                        BotLogger.severe((String)DefaultBotSession.LOGTAG, (Throwable)e);
                    }
                }
                catch (InterruptedException e) {
                    if (!DefaultBotSession.this.running) {
                        DefaultBotSession.this.receivedUpdates.clear();
                    }
                    BotLogger.debug((String)DefaultBotSession.LOGTAG, (Throwable)e);
                }
                catch (Exception global) {
                    BotLogger.severe((String)DefaultBotSession.LOGTAG, (Throwable)global);
                    try {
                        url = this;
                        synchronized (url) {
                            this.wait(this.exponentialBackOff.nextBackOffMillis());
                        }
                    }
                    catch (InterruptedException e) {
                        if (!DefaultBotSession.this.running) {
                            DefaultBotSession.this.receivedUpdates.clear();
                        }
                        BotLogger.debug((String)DefaultBotSession.LOGTAG, (Throwable)e);
                    }
                }
            }
            BotLogger.debug((String)DefaultBotSession.LOGTAG, (String)"Reader thread has being closed");
        }
    }
}

