/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.updatesreceivers;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.generics.Webhook;
import org.telegram.telegrambots.generics.WebhookBot;
import org.telegram.telegrambots.updatesreceivers.RestApi;

public class DefaultWebhook
implements Webhook {
    private String keystoreServerFile;
    private String keystoreServerPwd;
    private String internalUrl;
    private final RestApi restApi = new RestApi();

    @Inject
    public DefaultWebhook() throws TelegramApiRequestException {
    }

    public void setInternalUrl(String internalUrl) {
        this.internalUrl = internalUrl;
    }

    public void setKeyStore(String keyStore, String keyStorePassword) throws TelegramApiRequestException {
        this.keystoreServerFile = keyStore;
        this.keystoreServerPwd = keyStorePassword;
        DefaultWebhook.validateServerKeystoreFile(keyStore);
    }

    public void registerWebhook(WebhookBot callback) {
        this.restApi.registerCallback(callback);
    }

    public void startServer() throws TelegramApiRequestException {
        HttpServer grizzlyServer;
        ResourceConfig rc = new ResourceConfig();
        rc.register((Object)this.restApi);
        rc.register(JacksonFeature.class);
        if (this.keystoreServerFile != null && this.keystoreServerPwd != null) {
            SSLContextConfigurator sslContext = new SSLContextConfigurator();
            sslContext.setKeyStoreFile(this.keystoreServerFile);
            sslContext.setKeyStorePass(this.keystoreServerPwd);
            grizzlyServer = GrizzlyHttpServerFactory.createHttpServer((URI)this.getBaseURI(), (ResourceConfig)rc, (boolean)true, (SSLEngineConfigurator)new SSLEngineConfigurator(sslContext).setClientMode(false).setNeedClientAuth(false));
        } else {
            grizzlyServer = GrizzlyHttpServerFactory.createHttpServer((URI)this.getBaseURI(), (ResourceConfig)rc);
        }
        try {
            grizzlyServer.start();
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Error starting webhook server", (Throwable)e);
        }
    }

    private URI getBaseURI() {
        return URI.create(this.internalUrl);
    }

    private static void validateServerKeystoreFile(String keyStore) throws TelegramApiRequestException {
        File file = new File(keyStore);
        if (!file.exists() || !file.canRead()) {
            throw new TelegramApiRequestException("Can't find or access server keystore file.");
        }
    }
}

