/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.processor;

import java.util.LinkedHashMap;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeDefinitions;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.IAttributeDefinitionsAware;
import org.thymeleaf.model.AttributeValueQuotes;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring3.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.thymeleaf.standard.util.StandardProcessorUtils;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.Validate;
import org.unbescape.html.HtmlEscape;

public final class SpringMethodTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor
implements IAttributeDefinitionsAware {
    public static final int ATTR_PRECEDENCE = 990;
    public static final String TARGET_ATTR_NAME = "method";
    private static final TemplateMode TEMPLATE_MODE = TemplateMode.HTML;
    private static final String TYPE_ATTR_NAME = "type";
    private static final String NAME_ATTR_NAME = "name";
    private static final String VALUE_ATTR_NAME = "value";
    private AttributeDefinition targetAttributeDefinition;

    public SpringMethodTagProcessor(String dialectPrefix) {
        super(TEMPLATE_MODE, dialectPrefix, TARGET_ATTR_NAME, 990, false);
    }

    public void setAttributeDefinitions(AttributeDefinitions attributeDefinitions) {
        Validate.notNull((Object)attributeDefinitions, (String)"Attribute Definitions cannot be null");
        this.targetAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, TARGET_ATTR_NAME);
    }

    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementTagStructureHandler structureHandler) {
        String newAttributeValue = HtmlEscape.escapeHtml4Xml((String)(expressionResult == null ? null : expressionResult.toString()));
        if (newAttributeValue == null || newAttributeValue.length() == 0) {
            structureHandler.removeAttribute(this.targetAttributeDefinition.getAttributeName());
            structureHandler.removeAttribute(attributeName);
        } else {
            StandardProcessorUtils.replaceAttribute((IElementTagStructureHandler)structureHandler, (AttributeName)attributeName, (AttributeDefinition)this.targetAttributeDefinition, (String)TARGET_ATTR_NAME, (String)newAttributeValue);
        }
        if (newAttributeValue != null && "form".equalsIgnoreCase(tag.getElementCompleteName()) && !this.isMethodBrowserSupported(newAttributeValue)) {
            StandardProcessorUtils.setAttribute((IElementTagStructureHandler)structureHandler, (AttributeDefinition)this.targetAttributeDefinition, (String)TARGET_ATTR_NAME, (String)"post");
            IModelFactory modelFactory = context.getModelFactory();
            IModel hiddenMethodModel = modelFactory.createModel();
            String type = "hidden";
            String name = "_method";
            String value = RequestDataValueProcessorUtils.processFormFieldValue(context, "_method", newAttributeValue, "hidden");
            LinkedHashMap<String, String> hiddenAttributes = new LinkedHashMap<String, String>(4, 1.0f);
            hiddenAttributes.put(TYPE_ATTR_NAME, "hidden");
            hiddenAttributes.put(NAME_ATTR_NAME, "_method");
            hiddenAttributes.put(VALUE_ATTR_NAME, value);
            IStandaloneElementTag hiddenMethodElementTag = modelFactory.createStandaloneElementTag("input", hiddenAttributes, AttributeValueQuotes.DOUBLE, false, true);
            hiddenMethodModel.add((ITemplateEvent)hiddenMethodElementTag);
            structureHandler.insertImmediatelyAfter(hiddenMethodModel, false);
        }
    }

    protected boolean isMethodBrowserSupported(String method) {
        return "get".equalsIgnoreCase(method) || "post".equalsIgnoreCase(method);
    }
}

