/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.expression;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.thymeleaf.context.IExpressionContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.spring3.expression.Fields;
import org.thymeleaf.spring3.expression.Mvc;
import org.thymeleaf.spring3.expression.RequestDataValues;
import org.thymeleaf.spring3.expression.Themes;
import org.thymeleaf.standard.expression.StandardExpressionObjectFactory;

public class SpringStandardExpressionObjectFactory
extends StandardExpressionObjectFactory {
    public static final String FIELDS_EXPRESSION_OBJECT_NAME = "fields";
    public static final String THEMES_EXPRESSION_OBJECT_NAME = "themes";
    public static final String MVC_EXPRESSION_OBJECT_NAME = "mvc";
    public static final String REQUESTDATAVALUES_EXPRESSION_OBJECT_NAME = "requestdatavalues";
    public static final Set<String> ALL_EXPRESSION_OBJECT_NAMES;
    private static final Mvc MVC_EXPRESSION_OBJECT;

    public Set<String> getAllExpressionObjectNames() {
        return ALL_EXPRESSION_OBJECT_NAMES;
    }

    public Object buildObject(IExpressionContext context, String expressionObjectName) {
        if (MVC_EXPRESSION_OBJECT_NAME.equals(expressionObjectName)) {
            return MVC_EXPRESSION_OBJECT;
        }
        if (THEMES_EXPRESSION_OBJECT_NAME.equals(expressionObjectName)) {
            return new Themes(context);
        }
        if (FIELDS_EXPRESSION_OBJECT_NAME.equals(expressionObjectName)) {
            return new Fields(context);
        }
        if (REQUESTDATAVALUES_EXPRESSION_OBJECT_NAME.equals(expressionObjectName)) {
            if (context instanceof ITemplateContext) {
                return new RequestDataValues((ITemplateContext)context);
            }
            return null;
        }
        return super.buildObject(context, expressionObjectName);
    }

    static {
        MVC_EXPRESSION_OBJECT = new Mvc();
        LinkedHashSet<String> allExpressionObjectNames = new LinkedHashSet<String>();
        allExpressionObjectNames.addAll(StandardExpressionObjectFactory.ALL_EXPRESSION_OBJECT_NAMES);
        allExpressionObjectNames.add(FIELDS_EXPRESSION_OBJECT_NAME);
        allExpressionObjectNames.add(THEMES_EXPRESSION_OBJECT_NAME);
        allExpressionObjectNames.add(MVC_EXPRESSION_OBJECT_NAME);
        allExpressionObjectNames.add(REQUESTDATAVALUES_EXPRESSION_OBJECT_NAME);
        ALL_EXPRESSION_OBJECT_NAMES = Collections.unmodifiableSet(allExpressionObjectNames);
    }
}

