/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.context.web;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import ognl.Ognl;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.context.WebContext;
import org.thymeleaf.testing.templateengine.context.IProcessingContextBuilder;
import org.thymeleaf.testing.templateengine.context.ITestContext;
import org.thymeleaf.testing.templateengine.context.ITestContextExpression;
import org.thymeleaf.testing.templateengine.engine.TestExecutor;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.testable.ITest;

public class WebProcessingContextBuilder
implements IProcessingContextBuilder {
    public static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private static final String REQUEST_PARAMS_PREFIX = "param";
    private static final String REQUEST_ATTRS_PREFIX = "request";
    private static final String SESSION_ATTRS_PREFIX = "session";
    private static final String SERVLETCONTEXT_ATTRS_PREFIX = "application";

    @Override
    public final IContext build(ITest test) {
        Object exprResult;
        if (test == null) {
            return null;
        }
        ITestContext testContext = test.getContext();
        Locale locale = DEFAULT_LOCALE;
        ITestContextExpression localeExpression = testContext.getLocale();
        if (localeExpression != null && (exprResult = localeExpression.evaluate(Collections.EMPTY_MAP, DEFAULT_LOCALE)) != null) {
            locale = LocaleUtils.toLocale((String)exprResult.toString());
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        LinkedHashMap<String, Object[]> requestParameters = new LinkedHashMap<String, Object[]>();
        variables.put(REQUEST_PARAMS_PREFIX, requestParameters);
        LinkedHashMap<String, Object> requestAttributes = new LinkedHashMap<String, Object>();
        variables.put(REQUEST_ATTRS_PREFIX, requestAttributes);
        LinkedHashMap<String, Object> sessionAttributes = new LinkedHashMap<String, Object>();
        variables.put(SESSION_ATTRS_PREFIX, sessionAttributes);
        LinkedHashMap<String, Object> servletContextAttributes = new LinkedHashMap<String, Object>();
        variables.put(SERVLETCONTEXT_ATTRS_PREFIX, servletContextAttributes);
        for (Map.Entry<String, ITestContextExpression> entry : testContext.getVariables().entrySet()) {
            WebProcessingContextBuilder.resolve(entry.getKey(), entry.getValue(), variables, locale);
        }
        for (Map.Entry<String, ITestContextExpression> entry : testContext.getRequestParameters().entrySet()) {
            int firstPoint = entry.getKey().indexOf(46);
            String paramName = firstPoint == -1 ? entry.getKey() : entry.getKey().substring(0, firstPoint);
            String remainder = firstPoint == -1 ? "" : entry.getKey().substring(firstPoint);
            Object[] paramValues = new Object[((ITestContextExpression[])entry.getValue()).length];
            requestParameters.put(paramName, paramValues);
            int expressionsLen = ((ITestContextExpression[])entry.getValue()).length;
            for (int i = 0; i < expressionsLen; ++i) {
                WebProcessingContextBuilder.resolve("param." + paramName + "[" + i + "]" + remainder, ((ITestContextExpression[])entry.getValue())[i], variables, locale);
            }
        }
        for (Map.Entry<String, ITestContextExpression> entry : testContext.getRequestAttributes().entrySet()) {
            WebProcessingContextBuilder.resolve("request." + entry.getKey(), entry.getValue(), variables, locale);
        }
        for (Map.Entry<String, ITestContextExpression> entry : testContext.getSessionAttributes().entrySet()) {
            WebProcessingContextBuilder.resolve("session." + entry.getKey(), entry.getValue(), variables, locale);
        }
        for (Map.Entry<String, ITestContextExpression> entry : testContext.getServletContextAttributes().entrySet()) {
            WebProcessingContextBuilder.resolve("application." + entry.getKey(), entry.getValue(), variables, locale);
        }
        ServletContext servletContext = WebProcessingContextBuilder.createMockServletContext(servletContextAttributes);
        HttpSession httpSession = WebProcessingContextBuilder.createMockHttpSession(servletContext, sessionAttributes);
        HttpServletRequest request = WebProcessingContextBuilder.createMockHttpServletRequest(test, httpSession, requestAttributes, requestParameters, locale);
        HttpServletResponse response = WebProcessingContextBuilder.createMockHttpServletResponse();
        variables.remove(REQUEST_PARAMS_PREFIX);
        variables.remove(REQUEST_ATTRS_PREFIX);
        variables.remove(SESSION_ATTRS_PREFIX);
        variables.remove(SERVLETCONTEXT_ATTRS_PREFIX);
        this.doAdditionalVariableProcessing(test, request, response, servletContext, locale, variables);
        IWebContext context = this.doCreateWebContextInstance(test, request, response, servletContext, locale, variables);
        return context;
    }

    protected void doAdditionalVariableProcessing(ITest test, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Locale locale, Map<String, Object> variables) {
    }

    protected IWebContext doCreateWebContextInstance(ITest test, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Locale locale, Map<String, Object> variables) {
        return new WebContext(request, response, servletContext, locale, variables);
    }

    static final HttpServletRequest createMockHttpServletRequest(ITest test, HttpSession session, Map<String, Object> attributes, Map<String, Object[]> parameters, Locale locale) {
        String mimeType = "text/html";
        String characterEncoding = "UTF-8";
        String method = "GET";
        String contextName = "/testing";
        String protocol = "HTTP/1.1";
        String scheme = "http";
        int port = 80;
        String serverName = "testing-server";
        String servletPath = "/" + WebProcessingContextBuilder.testNameToServletPath(test.getName());
        String requestURI = "/testing" + servletPath;
        String requestURL = "http://testing-server" + requestURI;
        String queryString = WebProcessingContextBuilder.buildQueryString(parameters);
        int contentLength = -1;
        ObjectEnumeration headerNames = new ObjectEnumeration(null);
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getContentType()).thenReturn((Object)"text/html");
        Mockito.when((Object)request.getCharacterEncoding()).thenReturn((Object)"UTF-8");
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)request.getProtocol()).thenReturn((Object)"HTTP/1.1");
        Mockito.when((Object)request.getScheme()).thenReturn((Object)"http");
        Mockito.when((Object)request.getServerName()).thenReturn((Object)"testing-server");
        Mockito.when((Object)request.getServerPort()).thenReturn((Object)80);
        Mockito.when((Object)request.getContextPath()).thenReturn((Object)"/testing");
        Mockito.when((Object)request.getServletPath()).thenReturn((Object)servletPath);
        Mockito.when((Object)request.getRequestURI()).thenReturn((Object)requestURI);
        Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer(requestURL));
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)queryString);
        Mockito.when((Object)request.getLocale()).thenReturn((Object)locale);
        Mockito.when((Object)request.getLocales()).thenReturn(new ObjectEnumeration<Locale>(Arrays.asList(locale)));
        Mockito.when((Object)request.getContentLength()).thenReturn((Object)-1);
        Mockito.when((Object)request.getHeaderNames()).thenReturn(headerNames);
        Mockito.when((Object)request.getSession()).thenReturn((Object)session);
        Mockito.when((Object)request.getSession(Matchers.anyBoolean())).thenReturn((Object)session);
        Mockito.when((Object)request.getAttributeNames()).thenAnswer((Answer)new GetVariableNamesAnswer(attributes));
        Mockito.when((Object)request.getAttribute(Matchers.anyString())).thenAnswer((Answer)new GetAttributeAnswer(attributes));
        ((HttpServletRequest)Mockito.doAnswer((Answer)new SetAttributeAnswer(attributes)).when((Object)request)).setAttribute(Matchers.anyString(), Matchers.anyObject());
        ((HttpServletRequest)Mockito.doAnswer((Answer)new RemoveAttributeAnswer(attributes)).when((Object)request)).removeAttribute(Matchers.anyString());
        Mockito.when((Object)request.getParameterNames()).thenAnswer((Answer)new GetVariableNamesAnswer(parameters));
        Mockito.when((Object)request.getParameterValues(Matchers.anyString())).thenAnswer((Answer)new GetParameterValuesAnswer(parameters));
        Mockito.when((Object)request.getParameterMap()).thenAnswer((Answer)new GetParameterMapAnswer(parameters));
        Mockito.when((Object)request.getParameter(Matchers.anyString())).thenAnswer((Answer)new GetParameterAnswer(parameters));
        return request;
    }

    static final HttpSession createMockHttpSession(ServletContext context, Map<String, Object> attributes) {
        HttpSession session = (HttpSession)Mockito.mock(HttpSession.class);
        Mockito.when((Object)session.getServletContext()).thenReturn((Object)context);
        Mockito.when((Object)session.getAttributeNames()).thenAnswer((Answer)new GetVariableNamesAnswer(attributes));
        Mockito.when((Object)session.getAttribute(Matchers.anyString())).thenAnswer((Answer)new GetAttributeAnswer(attributes));
        ((HttpSession)Mockito.doAnswer((Answer)new SetAttributeAnswer(attributes)).when((Object)session)).setAttribute(Matchers.anyString(), Matchers.anyObject());
        ((HttpSession)Mockito.doAnswer((Answer)new RemoveAttributeAnswer(attributes)).when((Object)session)).removeAttribute(Matchers.anyString());
        return session;
    }

    static final HttpServletResponse createMockHttpServletResponse() {
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)response.encodeURL(Matchers.anyString())).thenAnswer((Answer)new EncodeUrlAnswer());
        return response;
    }

    static final ServletContext createMockServletContext(Map<String, Object> attributes) {
        String contextName = "/testing";
        ServletContext servletContext = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)servletContext.getAttributeNames()).thenAnswer((Answer)new GetVariableNamesAnswer(attributes));
        Mockito.when((Object)servletContext.getAttribute(Matchers.anyString())).thenAnswer((Answer)new GetAttributeAnswer(attributes));
        ((ServletContext)Mockito.doAnswer((Answer)new SetAttributeAnswer(attributes)).when((Object)servletContext)).setAttribute(Matchers.anyString(), Matchers.anyObject());
        ((ServletContext)Mockito.doAnswer((Answer)new RemoveAttributeAnswer(attributes)).when((Object)servletContext)).removeAttribute(Matchers.anyString());
        Mockito.when((Object)servletContext.getContextPath()).thenReturn((Object)"/testing");
        Mockito.when((Object)servletContext.getInitParameterNames()).thenReturn(new ObjectEnumeration(null));
        Mockito.when((Object)servletContext.getInitParameter(Matchers.anyString())).thenReturn(null);
        return servletContext;
    }

    private static void resolve(String expression, ITestContextExpression contextExpression, Map<String, Object> variables, Locale locale) {
        try {
            Object result = contextExpression.evaluate(variables, locale);
            Object parsedExpression = Ognl.parseExpression((String)expression);
            Ognl.setValue((Object)parsedExpression, variables, (Object)result);
        }
        catch (Throwable t) {
            throw new TestEngineExecutionException("Exception while trying to evaluate expression \"" + expression + "\" on context for test \"" + TestExecutor.getThreadTestName() + "\"", t);
        }
    }

    private static String testNameToServletPath(String testName) {
        String normalizedName = StringUtils.stripAccents((String)testName);
        if (normalizedName.contains("/")) {
            normalizedName = normalizedName.substring(normalizedName.lastIndexOf(47));
        }
        if (normalizedName.contains("\\")) {
            normalizedName = normalizedName.substring(normalizedName.lastIndexOf(92));
        }
        if (normalizedName.endsWith(".thtest")) {
            normalizedName = normalizedName.substring(0, normalizedName.length() - 7);
        }
        StringBuilder strBuilder = new StringBuilder();
        int nameLen = normalizedName.length();
        for (int i = 0; i < nameLen; ++i) {
            char c = normalizedName.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            strBuilder.append(c);
        }
        return strBuilder.toString();
    }

    private static String buildQueryString(Map<String, Object[]> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return null;
        }
        StringBuilder strBuilder = new StringBuilder();
        for (Map.Entry<String, Object[]> parameterEntry : parameters.entrySet()) {
            String parameterName = parameterEntry.getKey();
            Object[] parameterValues = parameterEntry.getValue();
            if (parameterValues == null || parameterValues.length == 0) {
                if (strBuilder.length() > 0) {
                    strBuilder.append('&');
                }
                strBuilder.append(parameterName);
                continue;
            }
            for (Object parameterValue : parameterValues) {
                if (strBuilder.length() > 0) {
                    strBuilder.append('&');
                }
                strBuilder.append(parameterName);
                if (parameterValue == null) continue;
                strBuilder.append("=");
                try {
                    strBuilder.append(URLEncoder.encode(parameterValue.toString(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return strBuilder.toString();
    }

    private static class EncodeUrlAnswer
    implements Answer<String> {
        public String answer(InvocationOnMock invocation) throws Throwable {
            return (String)invocation.getArguments()[0];
        }
    }

    private static class GetParameterMapAnswer
    implements Answer<Map<String, String[]>> {
        private final Map<String, Object[]> values;

        public GetParameterMapAnswer(Map<String, Object[]> values) {
            this.values = values;
        }

        public Map<String, String[]> answer(InvocationOnMock invocation) throws Throwable {
            HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
            for (Map.Entry<String, Object[]> valueEntry : this.values.entrySet()) {
                String parameterName = valueEntry.getKey();
                Object[] parameterValues = valueEntry.getValue();
                if (parameterValues == null) {
                    parameterMap.put(parameterName, null);
                    continue;
                }
                String[] parameterValuesArray = new String[parameterValues.length];
                for (int i = 0; i < parameterValuesArray.length; ++i) {
                    Object value = parameterValues[i];
                    parameterValuesArray[i] = value == null ? null : value.toString();
                }
                parameterMap.put(parameterName, parameterValuesArray);
            }
            return parameterMap;
        }
    }

    private static class GetParameterAnswer
    implements Answer<String> {
        private final Map<String, Object[]> values;

        public GetParameterAnswer(Map<String, Object[]> values) {
            this.values = values;
        }

        public String answer(InvocationOnMock invocation) throws Throwable {
            String parameterName = (String)invocation.getArguments()[0];
            Object[] parameterValues = this.values.get(parameterName);
            if (parameterValues == null) {
                return null;
            }
            Object value = parameterValues[0];
            return value == null ? null : value.toString();
        }
    }

    private static class GetParameterValuesAnswer
    implements Answer<String[]> {
        private final Map<String, Object[]> values;

        public GetParameterValuesAnswer(Map<String, Object[]> values) {
            this.values = values;
        }

        public String[] answer(InvocationOnMock invocation) throws Throwable {
            String parameterName = (String)invocation.getArguments()[0];
            Object[] parameterValues = this.values.get(parameterName);
            if (parameterValues == null) {
                return null;
            }
            String[] parameterValuesArray = new String[parameterValues.length];
            for (int i = 0; i < parameterValuesArray.length; ++i) {
                Object value = parameterValues[i];
                parameterValuesArray[i] = value == null ? null : value.toString();
            }
            return parameterValuesArray;
        }
    }

    private static class RemoveAttributeAnswer
    implements Answer<Object> {
        private final Map<String, Object> values;

        public RemoveAttributeAnswer(Map<String, Object> values) {
            this.values = values;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            String attributeName = (String)invocation.getArguments()[0];
            this.values.remove(attributeName);
            return null;
        }
    }

    private static class SetAttributeAnswer
    implements Answer<Object> {
        private final Map<String, Object> values;

        public SetAttributeAnswer(Map<String, Object> values) {
            this.values = values;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            String attributeName = (String)invocation.getArguments()[0];
            Object attributeValue = invocation.getArguments()[1];
            if (attributeValue == null) {
                this.values.remove(attributeName);
            } else {
                this.values.put(attributeName, attributeValue);
            }
            return null;
        }
    }

    private static class GetAttributeAnswer
    implements Answer<Object> {
        private final Map<String, Object> values;

        public GetAttributeAnswer(Map<String, Object> values) {
            this.values = values;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            String attributeName = (String)invocation.getArguments()[0];
            return this.values.get(attributeName);
        }
    }

    private static class GetVariableNamesAnswer
    implements Answer<Enumeration<?>> {
        private final Map<String, ?> values;

        public GetVariableNamesAnswer(Map<String, ?> values) {
            this.values = values;
        }

        public Enumeration<?> answer(InvocationOnMock invocation) throws Throwable {
            return new ObjectEnumeration<String>(this.values.keySet());
        }
    }

    private static class ObjectEnumeration<T>
    implements Enumeration<T> {
        private final Iterator<T> iterator;

        public ObjectEnumeration(Collection<T> values) {
            this.iterator = values != null ? new ArrayList<T>(values).iterator() : Collections.emptyList().iterator();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iterator.next();
        }
    }
}

