/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.engine;

import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.util.Validate;

final class TestNamer {
    private final Map<ITest, String> namesByTest = new HashMap<ITest, String>();
    private final Map<String, Integer> countersByName = new HashMap<String, Integer>();

    TestNamer() {
    }

    public synchronized String nameTest(ITest test) {
        Validate.notNull((Object)test, (String)"Test cannot be null");
        if (this.namesByTest.containsKey(test)) {
            return this.namesByTest.get(test);
        }
        if (test.hasName()) {
            String name = test.getName();
            Integer idForName = this.countersByName.get(name);
            idForName = idForName == null ? Integer.valueOf(1) : Integer.valueOf(idForName + 1);
            String indexedName = String.format("%s-%03d", name, idForName);
            this.namesByTest.put(test, indexedName);
            this.countersByName.put(name, idForName);
            return indexedName;
        }
        String className = test.getClass().getSimpleName();
        Integer idForName = this.countersByName.get(className);
        idForName = idForName == null ? Integer.valueOf(1) : Integer.valueOf(idForName + 1);
        String indexedName = String.format("%s-%03d", className, idForName);
        this.namesByTest.put(test, indexedName);
        this.countersByName.put(className, idForName);
        return indexedName;
    }
}

