/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.report;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.thymeleaf.testing.templateengine.report.AbstractTestReporter;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.testing.templateengine.testable.ITestIterator;
import org.thymeleaf.testing.templateengine.testable.ITestParallelizer;
import org.thymeleaf.testing.templateengine.testable.ITestResult;
import org.thymeleaf.testing.templateengine.testable.ITestSequence;

public abstract class AbstractTextualTestReporter
extends AbstractTestReporter {
    private static final String NOW_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final BigInteger NANOS_IN_MILLIS = BigInteger.valueOf(1000000L);

    protected AbstractTextualTestReporter() {
    }

    @Override
    public final void executionStart(String executionId) {
        this.outputMessage(executionId, this.msgExecutionStart(), 0, false);
    }

    public String msgExecutionStart() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[EXECUTION:START]");
        return strBuilder.toString();
    }

    @Override
    public final void executionEnd(String executionId, int okTests, int totalTests, long executionTimeNanos) {
        this.outputMessage(executionId, this.msgExecutionEnd(okTests, totalTests, executionTimeNanos), 0, false);
    }

    public String msgExecutionEnd(int okTests, int totalTests, long executionTimeNanos) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[EXECUTION:END]");
        strBuilder.append("[" + okTests + "]");
        strBuilder.append("[" + totalTests + "]");
        strBuilder.append("[" + executionTimeNanos + "]");
        strBuilder.append(" Tests OK: " + okTests + " of " + totalTests + (okTests < totalTests ? " (FAILED: " + (totalTests - okTests) + ")" : "") + ".");
        strBuilder.append(" Sequence executed in " + this.duration(executionTimeNanos));
        return strBuilder.toString();
    }

    @Override
    public final void sequenceStart(String executionId, int nestingLevel, ITestSequence sequence) {
        this.outputMessage(executionId, this.msgSequenceStart(sequence), nestingLevel, false);
    }

    public String msgSequenceStart(ITestSequence sequence) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[sequence:start]");
        if (sequence.hasName()) {
            strBuilder.append("[" + sequence.getName() + "]");
        }
        return strBuilder.toString();
    }

    @Override
    public final void sequenceEnd(String executionId, int nestingLevel, ITestSequence sequence, int okTests, int totalTests, long executionTimeNanos) {
        this.outputMessage(executionId, this.msgSequenceEnd(sequence, okTests, totalTests, executionTimeNanos), nestingLevel, false);
    }

    public String msgSequenceEnd(ITestSequence sequence, int okTests, int totalTests, long executionTimeNanos) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[sequence:end]");
        if (sequence.hasName()) {
            strBuilder.append("[" + sequence.getName() + "]");
        }
        strBuilder.append("[" + okTests + "]");
        strBuilder.append("[" + totalTests + "]");
        strBuilder.append("[" + executionTimeNanos + "]");
        strBuilder.append(" Tests OK: " + okTests + " of " + totalTests + (okTests < totalTests ? " (FAILED: " + (totalTests - okTests) + ")" : "") + ".");
        strBuilder.append(" Sequence executed in " + this.duration(executionTimeNanos));
        return strBuilder.toString();
    }

    @Override
    public final void iteratorStart(String executionId, int nestingLevel, ITestIterator iterator) {
        this.outputMessage(executionId, this.msgIteratorStart(iterator), nestingLevel, false);
    }

    public String msgIteratorStart(ITestIterator iterator) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[iterator:begin]");
        strBuilder.append("[" + iterator.getIterations() + "]");
        if (iterator.hasName()) {
            strBuilder.append("[" + iterator.getName() + "]");
        }
        return strBuilder.toString();
    }

    @Override
    public final void iteratorEnd(String executionId, int nestingLevel, ITestIterator iterator, int okTests, int totalTests, long executionTimeNanos) {
        this.outputMessage(executionId, this.msgIteratorEnd(iterator, okTests, totalTests, executionTimeNanos), nestingLevel, false);
    }

    public String msgIteratorEnd(ITestIterator iterator, int okTests, int totalTests, long executionTimeNanos) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[iterator:end]");
        if (iterator.hasName()) {
            strBuilder.append("[" + iterator.getName() + "]");
        }
        strBuilder.append("[" + iterator.getIterations() + "]");
        strBuilder.append("[" + okTests + "]");
        strBuilder.append("[" + totalTests + "]");
        strBuilder.append("[" + executionTimeNanos + "]");
        strBuilder.append(" Tests OK: " + okTests + " of " + totalTests + (okTests < totalTests ? " (FAILED: " + (totalTests - okTests) + ")" : "") + ".");
        strBuilder.append(" Iterator executed in " + this.duration(executionTimeNanos));
        return strBuilder.toString();
    }

    @Override
    public final void iterationStart(String executionId, int nestingLevel, ITestIterator iterator, int iterationNumber) {
        this.outputMessage(executionId, this.msgIterationStart(iterator, iterationNumber), nestingLevel, false);
    }

    public String msgIterationStart(ITestIterator iterator, int iterationNumber) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[iteration:begin]");
        if (iterator.hasName()) {
            strBuilder.append("[" + iterator.getName() + "]");
        }
        strBuilder.append("[" + iterationNumber + "]");
        strBuilder.append("[" + iterator.getIterations() + "]");
        return strBuilder.toString();
    }

    @Override
    public final void iterationEnd(String executionId, int nestingLevel, ITestIterator iterator, int iterationNumber, int okTests, int totalTests, long executionTimeNanos) {
        this.outputMessage(executionId, this.msgIterationEnd(iterator, iterationNumber, okTests, totalTests, executionTimeNanos), nestingLevel, false);
    }

    public String msgIterationEnd(ITestIterator iterator, int iterationNumber, int okTests, int totalTests, long executionTimeNanos) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[iteration:end]");
        if (iterator.hasName()) {
            strBuilder.append("[" + iterator.getName() + "]");
        }
        strBuilder.append("[" + iterationNumber + "]");
        strBuilder.append("[" + iterator.getIterations() + "]");
        strBuilder.append("[" + okTests + "]");
        strBuilder.append("[" + totalTests + "]");
        strBuilder.append("[" + executionTimeNanos + "]");
        strBuilder.append(" Tests OK: " + okTests + " of " + totalTests + (okTests < totalTests ? " (FAILED: " + (totalTests - okTests) + ")" : "") + ".");
        strBuilder.append(" Iteration executed in " + this.duration(executionTimeNanos));
        return strBuilder.toString();
    }

    @Override
    public final void parallelizerStart(String executionId, int nestingLevel, ITestParallelizer parallelizer) {
        this.outputMessage(executionId, this.msgParallelizerStart(parallelizer), nestingLevel, false);
    }

    public String msgParallelizerStart(ITestParallelizer parallelizer) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[parallelizer:begin]");
        strBuilder.append("[" + parallelizer.getNumThreads() + "]");
        if (parallelizer.hasName()) {
            strBuilder.append("[" + parallelizer.getName() + "]");
        }
        return strBuilder.toString();
    }

    @Override
    public final void parallelizerEnd(String executionId, int nestingLevel, ITestParallelizer parallelizer, int okTests, int totalTests, long executionTimeNanos) {
        this.outputMessage(executionId, this.msgParallelizerEnd(parallelizer, okTests, totalTests, executionTimeNanos), nestingLevel, false);
    }

    public String msgParallelizerEnd(ITestParallelizer parallelizer, int okTests, int totalTests, long executionTimeNanos) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[parallelizer:end]");
        if (parallelizer.hasName()) {
            strBuilder.append("[" + parallelizer.getName() + "]");
        }
        strBuilder.append("[" + parallelizer.getNumThreads() + "]");
        strBuilder.append("[" + okTests + "]");
        strBuilder.append("[" + totalTests + "]");
        strBuilder.append("[" + executionTimeNanos + "]");
        strBuilder.append(" Tests OK: " + okTests + " of " + totalTests + (okTests < totalTests ? " (FAILED: " + (totalTests - okTests) + ")" : "") + ".");
        strBuilder.append(" Parallelizer executed in " + this.duration(executionTimeNanos));
        return strBuilder.toString();
    }

    @Override
    public final void parallelThreadStart(String executionId, int nestingLevel, ITestParallelizer parallelizer, int threadNumber) {
        this.outputMessage(executionId, this.msgParallelThreadStart(parallelizer, threadNumber), nestingLevel, false);
    }

    public String msgParallelThreadStart(ITestParallelizer parallelizer, int threadNumber) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[parallelthread:begin]");
        if (parallelizer.hasName()) {
            strBuilder.append("[" + parallelizer.getName() + "]");
        }
        strBuilder.append("[" + threadNumber + "]");
        strBuilder.append("[" + parallelizer.getNumThreads() + "]");
        return strBuilder.toString();
    }

    @Override
    public final void parallelThreadEnd(String executionId, int nestingLevel, ITestParallelizer parallelizer, int threadNumber, int okTests, int totalTests, long executionTimeNanos) {
        this.outputMessage(executionId, this.msgParallelThreadEnd(parallelizer, threadNumber, okTests, totalTests, executionTimeNanos), nestingLevel, false);
    }

    public String msgParallelThreadEnd(ITestParallelizer parallelizer, int threadNumber, int okTests, int totalTests, long executionTimeNanos) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[parallelthread:end]");
        if (parallelizer.hasName()) {
            strBuilder.append("[" + parallelizer.getName() + "]");
        }
        strBuilder.append("[" + threadNumber + "]");
        strBuilder.append("[" + parallelizer.getNumThreads() + "]");
        strBuilder.append("[" + okTests + "]");
        strBuilder.append("[" + totalTests + "]");
        strBuilder.append("[" + executionTimeNanos + "]");
        strBuilder.append(" Tests OK: " + okTests + " of " + totalTests + (okTests < totalTests ? " (FAILED: " + (totalTests - okTests) + ")" : "") + ".");
        strBuilder.append(" Parallel thread executed in " + this.duration(executionTimeNanos));
        return strBuilder.toString();
    }

    @Override
    public final void reportTestStart(String executionId, int nestingLevel, ITest test, String testName) {
        this.outputMessage(executionId, this.msgTestStart(test, testName), nestingLevel, false);
    }

    public String msgTestStart(ITest test, String testName) {
        return null;
    }

    @Override
    public final void reportTestEnd(String executionId, int nestingLevel, ITest test, String testName, ITestResult result, long executionTimeNanos) {
        this.outputMessage(executionId, this.msgTestEnd(test, testName, result, executionTimeNanos), nestingLevel, !result.isOK());
    }

    public String msgTestEnd(ITest test, String testName, ITestResult result, long executionTimeNanos) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[test:end]");
        strBuilder.append("[" + testName + "]");
        strBuilder.append("[" + executionTimeNanos + "]");
        if (result.isOK()) {
            strBuilder.append("[OK]");
        } else {
            strBuilder.append("[KO]");
        }
        strBuilder.append(' ');
        if (result.isOK()) {
            strBuilder.append("Test executed OK");
        } else {
            strBuilder.append("Test FAILED");
        }
        if (result.hasMessage()) {
            strBuilder.append(": " + result.getMessage());
        } else {
            strBuilder.append(". ");
        }
        strBuilder.append(" Time: " + this.duration(executionTimeNanos) + ".");
        if (result.hasThrowable()) {
            if (result.isOK()) {
                strBuilder.append(" [Exception thrown: " + result.getThrowable().getClass().getName() + ": " + result.getThrowable().getMessage() + "]");
            } else {
                Throwable throwable = result.getThrowable();
                StringWriter writer = new StringWriter();
                PrintWriter printWriter = new PrintWriter(writer);
                throwable.printStackTrace(printWriter);
                strBuilder.append("\n" + writer.toString());
            }
        }
        return strBuilder.toString();
    }

    private void outputMessage(String executionId, String message, int nestingLevel, boolean error) {
        if (message != null) {
            this.output(this.formatLine(executionId, message, nestingLevel), error);
        }
    }

    protected String formatLine(String executionId, String message, int nestingLevel) {
        String threadName = Thread.currentThread().getName();
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("[" + this.now() + "][" + executionId + "][" + threadName + "] ");
        for (int i = 0; i < nestingLevel; ++i) {
            strBuilder.append("  ");
        }
        strBuilder.append(message);
        return strBuilder.toString();
    }

    protected abstract void output(String var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DATE_FORMAT.format(cal.getTime());
        }
    }

    private String duration(long nanos) {
        BigInteger nanosBI = BigInteger.valueOf(nanos);
        return nanosBI.toString() + "ns (" + nanosBI.divide(NANOS_IN_MILLIS) + "ms)";
    }
}

