/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class MultiValueProperties {
    private final Map<String, List<String>> values = new LinkedHashMap<String, List<String>>();

    public void load(InputStream inputStream) throws IOException {
        PropertiesSupport support = new PropertiesSupport(this.values);
        support.load(inputStream);
    }

    public boolean hasProperty(String propertyName) {
        return this.values.get(propertyName) != null;
    }

    public List<String> getProperty(String propertyName) {
        return this.values.get(propertyName);
    }

    public Set<Map.Entry<String, List<String>>> entrySet() {
        return this.values.entrySet();
    }

    private static class PropertiesSupport
    extends Properties {
        private static final long serialVersionUID = 6978654753874130829L;
        private final Map<String, List<String>> values;

        public PropertiesSupport(Map<String, List<String>> values) {
            this.values = values;
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            if (key == null || !(key instanceof String) || ((String)key).trim().equals("")) {
                throw new IllegalArgumentException("Cannot add key " + key + " to MultiValueProperties object");
            }
            String keyStr = (String)key;
            List<String> valuesForKey = this.values.get(keyStr);
            if (valuesForKey == null) {
                valuesForKey = new ArrayList<String>();
                this.values.put(keyStr, valuesForKey);
            }
            valuesForKey.add(value == null ? null : value.toString());
            return null;
        }
    }
}

