/*
 * Decompiled with CFR 0.152.
 */
package ise.library;

import ise.library.Navable;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class Nav
extends JToolBar
implements ActionListener {
    public static final String BACK = "back";
    public static final String FORWARD = "forward";
    public static final String CAN_GO_BACK = "canGoBack";
    public static final String CANNOT_GO_BACK = "cannotGoBack";
    public static final String CAN_GO_FORWARD = "canGoForward";
    public static final String CANNOT_GO_FORWARD = "cannotGoForward";
    private JButton back;
    private JButton forward;
    private Stack backStack;
    private Stack forwardStack;
    private Object currentNode = null;
    private Navable client;

    public Nav(Navable client) {
        if (client == null) {
            throw new IllegalArgumentException("client cannot be null");
        }
        this.client = client;
        this.setFloatable(false);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        try {
            this.back = new JButton();
            URL url = this.getClass().getClassLoader().getResource("images/Back16.gif");
            ImageIcon icon = null;
            if (url != null) {
                icon = new ImageIcon(url);
            }
            if (icon != null) {
                this.back.setIcon(icon);
            } else {
                this.back.setText("<");
            }
            this.forward = new JButton();
            url = this.getClass().getClassLoader().getResource("images/Forward16.gif");
            icon = null;
            if (url != null) {
                icon = new ImageIcon(url);
            }
            if (icon != null) {
                this.forward.setIcon(icon);
            } else {
                this.forward.setText(">");
            }
            this.back.setMargin(new Insets(0, 0, 0, 0));
            this.forward.setMargin(new Insets(0, 0, 0, 0));
            this.back.setActionCommand(BACK);
            this.forward.setActionCommand(FORWARD);
            this.back.addActionListener(this);
            this.forward.addActionListener(this);
            this.add(this.back);
            this.add(this.forward);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.backStack = new Stack();
        this.forwardStack = new Stack();
        this.clearStacks();
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals(BACK)) {
            this.goBack();
        } else if (ae.getActionCommand().equals(FORWARD)) {
            this.goForward();
        } else if (ae.getActionCommand().equals(CAN_GO_BACK)) {
            this.back.setEnabled(true);
        } else if (ae.getActionCommand().equals(CANNOT_GO_BACK)) {
            this.back.setEnabled(false);
        } else if (ae.getActionCommand().equals(CAN_GO_FORWARD)) {
            this.forward.setEnabled(true);
        } else if (ae.getActionCommand().equals(CANNOT_GO_FORWARD)) {
            this.forward.setEnabled(false);
        }
    }

    public void clearStacks() {
        this.backStack.clear();
        this.forwardStack.clear();
        this.setButtonState();
    }

    public void goBack() {
        if (!this.backStack.empty()) {
            if (this.currentNode != null) {
                this.forwardStack.push(this.currentNode);
            }
            this.currentNode = this.backStack.pop();
            this.navigate(this.currentNode);
        }
        this.setButtonState();
    }

    public void goForward() {
        if (!this.forwardStack.empty()) {
            if (this.currentNode != null) {
                this.backStack.push(this.currentNode);
            }
            this.currentNode = this.forwardStack.pop();
            this.navigate(this.currentNode);
        }
        this.setButtonState();
    }

    private void navigate(Object node) {
        this.client.setPosition(node);
    }

    private void setButtonState() {
        this.back.setEnabled(!this.backStack.empty());
        this.forward.setEnabled(!this.forwardStack.empty());
    }

    public void update(Object node) {
        if (node != this.currentNode) {
            if (this.currentNode != null) {
                this.backStack.push(this.currentNode);
            }
            this.currentNode = node;
            this.forwardStack.clear();
        }
        this.setButtonState();
    }
}

