/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static void copyResources(Path resourceAsPath, Path targetDirectory) {
        block9: {
            try {
                String resourceName = "/" + resourceAsPath;
                Files.createDirectories(targetDirectory, new FileAttribute[0]);
                URI uri = ResourceUtil.class.getResource(resourceName).toURI();
                if (uri.getScheme().equalsIgnoreCase("jar")) {
                    try (FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                        Path myPath = fileSystem.getPath(resourceName, new String[0]);
                        ResourceUtil.copyRecursive(myPath, targetDirectory);
                        break block9;
                    }
                }
                Path myPath = Paths.get(uri);
                ResourceUtil.copyRecursive(myPath, targetDirectory);
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void copyRecursive(final Path from, final Path targetDirectory) throws IOException {
        Files.walkFileTree(from, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                super.preVisitDirectory(dir, attrs);
                Path currentTarget = targetDirectory.resolve(from.relativize(dir).toString());
                Files.createDirectories(currentTarget, new FileAttribute[0]);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                super.visitFile(file, attrs);
                Files.copy(file, targetDirectory.resolve(from.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

