/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.utplsql.api.exception.InvalidVersionException;

public class Version
implements Comparable<Version> {
    public static final Version V3_0_0 = new Version("3.0.0", 3, 0, 0, null, true);
    public static final Version V3_0_1 = new Version("3.0.1", 3, 0, 1, null, true);
    public static final Version V3_0_2 = new Version("3.0.2", 3, 0, 2, null, true);
    public static final Version V3_0_3 = new Version("3.0.3", 3, 0, 3, null, true);
    public static final Version V3_0_4 = new Version("3.0.4", 3, 0, 4, null, true);
    public static final Version V3_1_0 = new Version("3.1.0", 3, 1, 0, 1847, true);
    public static final Version V3_1_1 = new Version("3.1.1", 3, 1, 1, 1865, true);
    public static final Version V3_1_2 = new Version("3.1.2", 3, 1, 2, 2130, true);
    public static final Version V3_1_3 = new Version("3.1.3", 3, 1, 3, 2398, true);
    public static final Version V3_1_4 = new Version("3.1.4", 3, 1, 4, 2223, true);
    public static final Version V3_1_5 = new Version("3.1.5", 3, 1, 5, 2707, true);
    public static final Version V3_1_6 = new Version("3.1.6", 3, 1, 6, 2729, true);
    public static final Version V3_1_7 = new Version("3.1.7", 3, 1, 7, 3085, true);
    public static final Version V3_1_8 = new Version("3.1.8", 3, 1, 8, 3188, true);
    public static final Version V3_1_9 = new Version("3.1.9", 3, 1, 9, 3268, true);
    public static final Version V3_1_10 = new Version("3.1.10", 3, 1, 10, 3347, true);
    public static final Version V3_1_11 = new Version("3.1.11", 3, 1, 11, 3557, true);
    public static final Version V3_1_12 = new Version("3.1.12", 3, 1, 12, 3876, true);
    public static final Version V3_1_13 = new Version("3.1.13", 3, 1, 13, 3592, true);
    private static final Map<String, Version> knownVersions = Stream.of(V3_0_0, V3_0_1, V3_0_2, V3_0_3, V3_0_4, V3_1_0, V3_1_1, V3_1_2, V3_1_3, V3_1_4, V3_1_5, V3_1_6, V3_1_7, V3_1_8, V3_1_9, V3_1_10, V3_1_11, V3_1_13).collect(Collectors.toMap(Version::toString, Function.identity()));
    public static final Version LATEST = V3_1_13;
    private final String origString;
    private final Integer major;
    private final Integer minor;
    private final Integer bugfix;
    private final Integer build;
    private final boolean valid;

    private Version(String origString, @Nullable Integer major, @Nullable Integer minor, @Nullable Integer bugfix, @Nullable Integer build, boolean valid) {
        this.origString = origString;
        this.major = major;
        this.minor = minor;
        this.bugfix = bugfix;
        this.build = build;
        this.valid = valid;
    }

    @Deprecated
    public Version(String versionString) {
        Objects.requireNonNull(versionString);
        Version dummy = Version.parseVersionString(versionString);
        this.origString = dummy.origString;
        this.major = dummy.major;
        this.minor = dummy.minor;
        this.bugfix = dummy.bugfix;
        this.build = dummy.build;
        this.valid = dummy.valid;
    }

    public static Version create(String versionString) {
        String origString = Objects.requireNonNull(versionString).trim();
        Version version = knownVersions.get(origString);
        return version != null ? version : Version.parseVersionString(origString);
    }

    private static Version parseVersionString(String origString) {
        Integer major = null;
        Integer minor = null;
        Integer bugfix = null;
        Integer build = null;
        boolean valid = false;
        Pattern p = Pattern.compile("([0-9]+)\\.?([0-9]+)?\\.?([0-9]+)?\\.?([0-9]+)?");
        Matcher m = p.matcher(origString);
        try {
            if (m.find()) {
                if (m.group(1) != null) {
                    major = Integer.valueOf(m.group(1));
                }
                if (m.group(2) != null) {
                    minor = Integer.valueOf(m.group(2));
                }
                if (m.group(3) != null) {
                    bugfix = Integer.valueOf(m.group(3));
                }
                if (m.group(4) != null) {
                    build = Integer.valueOf(m.group(4));
                }
                valid = major != null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new Version(origString, major, minor, bugfix, build, valid);
    }

    public String toString() {
        return this.origString;
    }

    @Nullable
    public Integer getMajor() {
        return this.major;
    }

    @Nullable
    public Integer getMinor() {
        return this.minor;
    }

    @Nullable
    public Integer getBugfix() {
        return this.bugfix;
    }

    @Nullable
    public Integer getBuild() {
        return this.build;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getNormalizedString() {
        if (this.isValid()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.major);
            if (this.minor != null) {
                sb.append(".").append(this.minor);
            }
            if (this.bugfix != null) {
                sb.append(".").append(this.bugfix);
            }
            if (this.build != null) {
                sb.append(".").append(this.build);
            }
            return sb.toString();
        }
        return "invalid";
    }

    private int compareToWithNulls(@Nullable Integer i1, @Nullable Integer i2) {
        return this.compareToWithNulls(i1, i2, false);
    }

    private int compareToWithNulls(@Nullable Integer i1, @Nullable Integer i2, boolean nullMeansEqual) {
        if (i1 == null && i2 == null) {
            return 0;
        }
        if (i1 == null) {
            return nullMeansEqual ? 0 : -1;
        }
        if (i2 == null) {
            return 1;
        }
        return i1.compareTo(i2);
    }

    @Override
    public int compareTo(Version o) {
        return this.compareTo(o, false);
    }

    public int compareTo(Version o, boolean nullMeansEqual) {
        if (this.isValid() && o.isValid()) {
            int curResult = this.compareToWithNulls(this.getMajor(), o.getMajor(), nullMeansEqual);
            if (curResult != 0) {
                return curResult;
            }
            curResult = this.compareToWithNulls(this.getMinor(), o.getMinor(), nullMeansEqual);
            if (curResult != 0) {
                return curResult;
            }
            curResult = this.compareToWithNulls(this.getBugfix(), o.getBugfix(), nullMeansEqual);
            if (curResult != 0) {
                return curResult;
            }
            curResult = this.compareToWithNulls(this.getBuild(), o.getBuild(), nullMeansEqual);
            return curResult;
        }
        return 0;
    }

    private void versionsAreValid(Version v) throws InvalidVersionException {
        if (!this.isValid()) {
            throw new InvalidVersionException(this);
        }
        if (!v.isValid()) {
            throw new InvalidVersionException(v);
        }
    }

    public boolean isGreaterOrEqualThan(Version v) throws InvalidVersionException {
        this.versionsAreValid(v);
        return this.compareTo(v, true) >= 0;
    }

    public boolean isGreaterThan(Version v) throws InvalidVersionException {
        this.versionsAreValid(v);
        return this.compareTo(v) > 0;
    }

    public boolean isLessOrEqualThan(Version v) throws InvalidVersionException {
        this.versionsAreValid(v);
        return this.compareTo(v, true) <= 0;
    }

    public boolean isLessThan(Version v) throws InvalidVersionException {
        this.versionsAreValid(v);
        return this.compareTo(v) < 0;
    }
}

