/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.compatibility;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.utplsql.api.TestRunnerOptions;
import org.utplsql.api.Version;
import org.utplsql.api.compatibility.OptionalFeatures;
import org.utplsql.api.db.DatabaseInformation;
import org.utplsql.api.db.DefaultDatabaseInformation;
import org.utplsql.api.exception.DatabaseNotCompatibleException;
import org.utplsql.api.outputBuffer.OutputBuffer;
import org.utplsql.api.outputBuffer.OutputBufferProvider;
import org.utplsql.api.reporter.Reporter;
import org.utplsql.api.testRunner.TestRunnerStatement;
import org.utplsql.api.testRunner.TestRunnerStatementProvider;

public class CompatibilityProxy {
    public static final String UTPLSQL_COMPATIBILITY_VERSION = "3";
    private final DatabaseInformation databaseInformation;
    private Version utPlsqlVersion;
    private final Version realDbPlsqlVersion;
    private boolean compatible = false;

    public CompatibilityProxy(Connection conn) throws SQLException {
        this(conn, null, null);
    }

    @Deprecated
    public CompatibilityProxy(Connection conn, boolean skipCompatibilityCheck) throws SQLException {
        this(conn, skipCompatibilityCheck, null);
    }

    @Deprecated
    public CompatibilityProxy(Connection conn, boolean skipCompatibilityCheck, @Nullable DatabaseInformation databaseInformation) throws SQLException {
        this(conn, skipCompatibilityCheck ? Version.LATEST : null, databaseInformation);
    }

    public CompatibilityProxy(Connection conn, @Nullable DatabaseInformation databaseInformation) throws SQLException {
        this(conn, null, databaseInformation);
    }

    public CompatibilityProxy(Connection conn, @Nullable Version assumedUtPlsVersion) throws SQLException {
        this(conn, assumedUtPlsVersion, null);
    }

    public CompatibilityProxy(Connection conn, @Nullable Version assumedUtPlsqlVersion, @Nullable DatabaseInformation databaseInformation) throws SQLException {
        this.databaseInformation = databaseInformation != null ? databaseInformation : new DefaultDatabaseInformation();
        this.realDbPlsqlVersion = this.databaseInformation.getUtPlsqlFrameworkVersion(conn);
        if (assumedUtPlsqlVersion != null) {
            this.utPlsqlVersion = assumedUtPlsqlVersion;
            this.compatible = this.utPlsqlVersion.getNormalizedString().startsWith(UTPLSQL_COMPATIBILITY_VERSION);
        } else {
            this.doCompatibilityCheckWithDatabase(conn);
        }
    }

    private void doCompatibilityCheckWithDatabase(Connection conn) throws DatabaseNotCompatibleException {
        this.utPlsqlVersion = this.realDbPlsqlVersion;
        Version clientVersion = Version.create(UTPLSQL_COMPATIBILITY_VERSION);
        if (this.utPlsqlVersion == null) {
            throw new DatabaseNotCompatibleException("Could not get database version", clientVersion, null, null);
        }
        if (this.utPlsqlVersion.getMajor() == null) {
            throw new DatabaseNotCompatibleException("Illegal database version: " + this.utPlsqlVersion.toString(), clientVersion, this.utPlsqlVersion, null);
        }
        if (OptionalFeatures.FRAMEWORK_COMPATIBILITY_CHECK.isAvailableFor(this.utPlsqlVersion)) {
            try {
                this.compatible = this.versionCompatibilityCheck(conn, UTPLSQL_COMPATIBILITY_VERSION, null);
            }
            catch (SQLException e) {
                throw new DatabaseNotCompatibleException("Compatibility-check failed with error. Aborting. Reason: " + e.getMessage(), clientVersion, Version.create("Unknown"), (Throwable)e);
            }
        } else {
            this.compatible = this.versionCompatibilityCheckPre303(UTPLSQL_COMPATIBILITY_VERSION);
        }
    }

    private boolean versionCompatibilityCheck(Connection conn, String requested, String current) throws SQLException {
        try {
            return this.databaseInformation.frameworkCompatibilityCheck(conn, requested, current) == 1;
        }
        catch (SQLException e) {
            if (e.getErrorCode() == 6550) {
                return false;
            }
            throw e;
        }
    }

    private boolean versionCompatibilityCheckPre303(String versionRequested) {
        Version requestedVersion = Version.create(versionRequested);
        Objects.requireNonNull(this.utPlsqlVersion.getMajor(), "Illegal database Version: " + this.utPlsqlVersion.toString());
        return Objects.equals(this.utPlsqlVersion.getMajor(), requestedVersion.getMajor()) && (requestedVersion.getMinor() == null || requestedVersion.getMinor().equals(this.utPlsqlVersion.getMinor()));
    }

    public void failOnNotCompatible() throws DatabaseNotCompatibleException {
        if (!this.isCompatible()) {
            throw new DatabaseNotCompatibleException(this.utPlsqlVersion);
        }
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    @Deprecated
    public Version getDatabaseVersion() {
        return this.utPlsqlVersion;
    }

    public Version getUtPlsqlVersion() {
        return this.utPlsqlVersion;
    }

    public Version getRealDbPlsqlVersion() {
        return this.realDbPlsqlVersion;
    }

    public String getVersionDescription() {
        if (this.utPlsqlVersion != this.realDbPlsqlVersion) {
            return this.realDbPlsqlVersion.toString() + " (Assumed: " + this.utPlsqlVersion.toString() + ")";
        }
        return this.utPlsqlVersion.toString();
    }

    public TestRunnerStatement getTestRunnerStatement(TestRunnerOptions options, Connection conn) throws SQLException {
        return TestRunnerStatementProvider.getCompatibleTestRunnerStatement(this.utPlsqlVersion, options, conn);
    }

    public OutputBuffer getOutputBuffer(Reporter reporter, Connection conn) throws SQLException {
        return OutputBufferProvider.getCompatibleOutputBuffer(this.utPlsqlVersion, reporter, conn);
    }
}

