/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.compatibility;

import java.sql.Connection;
import java.sql.SQLException;
import org.utplsql.api.Version;
import org.utplsql.api.compatibility.CompatibilityProxy;
import org.utplsql.api.exception.InvalidVersionException;

public enum OptionalFeatures {
    FAIL_ON_ERROR("3.0.3.1266", null),
    FRAMEWORK_COMPATIBILITY_CHECK("3.0.3.1266", null),
    CUSTOM_REPORTERS("3.1.0.1849", null),
    CLIENT_CHARACTER_SET("3.1.2.2130", null),
    RANDOM_EXECUTION_ORDER("3.1.7.2795", null),
    TAGS("3.1.7.3006", null),
    EXPR("3.1.13", null);

    private final Version minVersion;
    private final Version maxVersion;

    private OptionalFeatures(String minVersion, String maxVersion) {
        this.minVersion = minVersion != null ? Version.create(minVersion) : null;
        this.maxVersion = maxVersion != null ? Version.create(maxVersion) : null;
    }

    public boolean isAvailableFor(Version version) {
        try {
            return !(this.minVersion != null && !version.isGreaterOrEqualThan(this.minVersion) || this.maxVersion != null && !this.maxVersion.isGreaterOrEqualThan(version));
        }
        catch (InvalidVersionException e) {
            return false;
        }
    }

    public boolean isAvailableFor(Connection conn) throws SQLException {
        CompatibilityProxy proxy = new CompatibilityProxy(conn);
        return this.isAvailableFor(proxy.getUtPlsqlVersion());
    }

    public Version getMinVersion() {
        return this.minVersion;
    }

    public Version getMaxVersion() {
        return this.maxVersion;
    }
}

