/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.outputBuffer;

import java.io.PrintStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.utplsql.api.outputBuffer.OutputBuffer;
import org.utplsql.api.reporter.Reporter;

class NonOutputBuffer
implements OutputBuffer {
    private final Reporter reporter;

    NonOutputBuffer(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public Reporter getReporter() {
        return this.reporter;
    }

    @Override
    public OutputBuffer setFetchSize(int fetchSize) {
        return this;
    }

    @Override
    public void printAvailable(Connection conn, PrintStream ps) {
        ArrayList<PrintStream> printStreams = new ArrayList<PrintStream>(1);
        printStreams.add(ps);
        this.printAvailable(conn, printStreams);
    }

    @Override
    public void printAvailable(Connection conn, List<PrintStream> printStreams) {
        this.fetchAvailable(conn, s -> {
            for (PrintStream ps : printStreams) {
                ps.println((String)s);
            }
        });
    }

    @Override
    public void fetchAvailable(Connection conn, Consumer<String> onLineFetched) {
        onLineFetched.accept(null);
    }

    @Override
    public List<String> fetchAll(Connection conn) {
        return new ArrayList<String>();
    }
}

