/*
 * Decompiled with CFR 0.152.
 */
package org.utplsql.api.reporter.inspect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleType;
import oracle.sql.ORAData;
import org.utplsql.api.compatibility.CompatibilityProxy;
import org.utplsql.api.reporter.Reporter;
import org.utplsql.api.reporter.ReporterFactory;
import org.utplsql.api.reporter.inspect.AbstractReporterInspector;
import org.utplsql.api.reporter.inspect.ReporterInfo;

class ReporterInspector310
extends AbstractReporterInspector {
    private final Map<String, String> registeredReporterFactoryMethods;
    private final Set<ReporterInfo> infos;

    ReporterInspector310(ReporterFactory reporterFactory, Connection conn) throws SQLException {
        super(reporterFactory, conn);
        this.registeredReporterFactoryMethods = reporterFactory.getRegisteredReporterInfo();
        HashSet<ReporterInfo> reporterInfos = new HashSet<ReporterInfo>();
        try (PreparedStatement stmt = this.connection.prepareStatement("select * from table(ut_runner.get_reporters_list) order by 1");
             ResultSet rs = stmt.executeQuery();){
            while (rs.next()) {
                reporterInfos.add(this.getReporterInfo(rs.getString(1)));
            }
        }
        this.infos = reporterInfos;
    }

    @Override
    public List<ReporterInfo> getReporterInfos() {
        return new ArrayList<ReporterInfo>(this.infos);
    }

    private ReporterInfo getReporterInfo(String reporterNameWithOwner) throws SQLException {
        String reporterName = reporterNameWithOwner.substring(reporterNameWithOwner.indexOf(".") + 1).toUpperCase();
        ReporterInfo.Type type = ReporterInfo.Type.SQL;
        String description = this.getDescription(reporterName);
        if (this.registeredReporterFactoryMethods.containsKey(reporterName)) {
            type = ReporterInfo.Type.SQL_WITH_JAVA;
            description = description + "\n" + this.registeredReporterFactoryMethods.get(reporterName);
        }
        return new ReporterInfo(reporterName, type, description);
    }

    private String getDescription(String reporterName) throws SQLException {
        CompatibilityProxy compatibilityProxy = new CompatibilityProxy(this.connection);
        Reporter reporter = this.reporterFactory.createReporter(reporterName).init(this.connection, compatibilityProxy, this.reporterFactory);
        OracleConnection oraCon = this.connection.unwrap(OracleConnection.class);
        try (OracleCallableStatement stmt = (OracleCallableStatement)oraCon.prepareCall("{ ? = call ?.get_description() }");){
            stmt.registerOutParameter(1, (SQLType)OracleType.VARCHAR2);
            stmt.setORAData(2, (ORAData)reporter);
            stmt.execute();
            String string = stmt.getString(1);
            return string;
        }
    }
}

