/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.datetime.markup.html.basic;

import java.util.Date;
import org.apache.wicket.IGenericComponent;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.wicketstuff.datetime.DateConverter;
import org.wicketstuff.datetime.PatternDateConverter;
import org.wicketstuff.datetime.StyleDateConverter;

public class DateLabel
extends Label
implements IGenericComponent<Date, DateLabel> {
    private static final long serialVersionUID = 1L;
    private String after;
    private String before;
    private final DateConverter converter;

    public static DateLabel forDatePattern(String id, IModel<Date> model, String datePattern) {
        return new DateLabel(id, model, new PatternDateConverter(datePattern, true));
    }

    public static DateLabel forDatePattern(String id, String datePattern) {
        return DateLabel.forDatePattern(id, null, datePattern);
    }

    public static DateLabel forDateStyle(String id, IModel<Date> model, String dateStyle) {
        return new DateLabel(id, model, new StyleDateConverter(dateStyle, true));
    }

    public static DateLabel forDateStyle(String id, String dateStyle) {
        return DateLabel.forDateStyle(id, null, dateStyle);
    }

    public static DateLabel forShortStyle(String id) {
        return DateLabel.forShortStyle(id, null);
    }

    public static DateLabel forShortStyle(String id, IModel<Date> model) {
        return new DateLabel(id, model, new StyleDateConverter(true));
    }

    public static DateLabel withConverter(String id, DateConverter converter) {
        return DateLabel.withConverter(id, null, converter);
    }

    public static DateLabel withConverter(String id, IModel<Date> model, DateConverter converter) {
        return new DateLabel(id, model, converter);
    }

    public DateLabel(String id, DateConverter converter) {
        this(id, null, converter);
    }

    public DateLabel(String id, IModel<Date> model, DateConverter converter) {
        super(id, model);
        if (converter == null) {
            throw new IllegalStateException("converter may not be null");
        }
        this.converter = converter;
    }

    public String getAfter() {
        return this.after;
    }

    public String getBefore() {
        return this.before;
    }

    protected IConverter<?> createConverter(Class<?> type) {
        if (Date.class.isAssignableFrom(type)) {
            return this.converter;
        }
        return null;
    }

    public void setAfter(String after) {
        this.after = after;
    }

    public void setBefore(String before) {
        this.before = before;
    }

    public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
        Object s = this.getDefaultModelObjectAsString();
        if (this.before != null) {
            s = this.before + (String)s;
        }
        if (this.after != null) {
            s = (String)s + this.after;
        }
        this.replaceComponentTagBody(markupStream, openTag, (CharSequence)s);
    }
}

