/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.service;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

public class ApplicationClientDeploymentService
implements Service {
    private final File path;
    private final Consumer<ApplicationClientDeploymentService> consumer;
    private final Supplier<ModelControllerClientFactory> clientFactorySupplier;
    private final Supplier<ExecutorService> executorServiceSupplier;
    private final CountDownLatch deploymentCompleteLatch = new CountDownLatch(1);

    public ApplicationClientDeploymentService(Consumer<ApplicationClientDeploymentService> consumer, File path, Supplier<ModelControllerClientFactory> clientFactorySupplier, Supplier<ExecutorService> executorServiceSupplier) {
        this.consumer = consumer;
        this.path = path;
        this.clientFactorySupplier = clientFactorySupplier;
        this.executorServiceSupplier = executorServiceSupplier;
    }

    public synchronized void start(StartContext context) {
        DeployTask task = new DeployTask();
        Thread thread = new Thread(new DeploymentTask(new OperationBuilder(task.getUpdate()).build()));
        thread.start();
        this.consumer.accept(this);
    }

    public synchronized void stop(StopContext context) {
        this.consumer.accept(null);
    }

    public CountDownLatch getDeploymentCompleteLatch() {
        return this.deploymentCompleteLatch;
    }

    private final class DeployTask {
        private DeployTask() {
        }

        ModelNode getUpdate() {
            ModelNode address = new ModelNode().add("deployment", ApplicationClientDeploymentService.this.path.getName());
            ModelNode addOp = Util.getEmptyOperation((String)"add", (ModelNode)address);
            addOp.get("content").set(this.createContent());
            ModelNode deployOp = Util.getEmptyOperation((String)"deploy", (ModelNode)address);
            return this.getCompositeUpdate(addOp, deployOp);
        }

        ModelNode createContent() {
            ModelNode content = new ModelNode();
            ModelNode contentItem = content.get(0);
            contentItem.get("path").set(ApplicationClientDeploymentService.this.path.getAbsolutePath());
            contentItem.get("archive").set(!ApplicationClientDeploymentService.this.path.isDirectory());
            return content;
        }

        private ModelNode getCompositeUpdate(ModelNode ... updates) {
            ModelNode op = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
            ModelNode steps = op.get("steps");
            for (ModelNode update : updates) {
                steps.add(update);
            }
            return op;
        }
    }

    private class DeploymentTask
    implements Runnable {
        private final Operation deploymentOp;

        private DeploymentTask(Operation deploymentOp) {
            this.deploymentOp = deploymentOp;
        }

        @Override
        public void run() {
            try (LocalModelControllerClient controllerClient = ApplicationClientDeploymentService.this.clientFactorySupplier.get().createSuperUserClient((Executor)ApplicationClientDeploymentService.this.executorServiceSupplier.get());){
                ModelNode result = controllerClient.execute(this.deploymentOp);
                if (!"success".equals(result.get("outcome").asString())) {
                    System.exit(1);
                }
                ApplicationClientDeploymentService.this.deploymentCompleteLatch.countDown();
            }
        }
    }
}

