/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.eesecurity;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.wildfly.extension.eesecurity.EESecurityAnnotationProcessor;

class EESecurityDependencyProcessor
implements DeploymentUnitProcessor {
    EESecurityDependencyProcessor() {
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        DeploymentUnit top = unit.getParent() == null ? unit : unit.getParent();
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpec = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, "jakarta.security.enterprise.api", false, false, true, false));
        Boolean securityPresent = (Boolean)top.getAttachment(EESecurityAnnotationProcessor.SECURITY_PRESENT);
        if (securityPresent != null && securityPresent.booleanValue()) {
            moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, "org.wildfly.security.jakarta.security", false, false, true, false));
        }
    }
}

