/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.internal;

import com.github.tomakehurst.wiremock.common.Pair;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.Status;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.atomic.AtomicReference;
import org.wiremock.grpc.dsl.WireMockGrpc;
import org.wiremock.grpc.internal.BaseCallHandler;
import org.wiremock.grpc.internal.GrpcFilter;
import org.wiremock.grpc.internal.GrpcRequest;
import org.wiremock.grpc.internal.GrpcStatusUtils;
import org.wiremock.grpc.internal.JsonMessageConverter;

public class ClientStreamingServerCallHandler
extends BaseCallHandler
implements ServerCalls.ClientStreamingMethod<DynamicMessage, DynamicMessage> {
    public ClientStreamingServerCallHandler(StubRequestHandler stubRequestHandler, Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.MethodDescriptor methodDescriptor, JsonMessageConverter jsonMessageConverter) {
        super(stubRequestHandler, serviceDescriptor, methodDescriptor, jsonMessageConverter);
    }

    public StreamObserver<DynamicMessage> invoke(final StreamObserver<DynamicMessage> responseObserver) {
        final GrpcFilter.ServerAddress serverAddress = GrpcFilter.ServerAddress.get();
        final AtomicReference firstResponse = new AtomicReference();
        final AtomicReference responseStatus = new AtomicReference();
        final AtomicReference statusReason = new AtomicReference();
        return new StreamObserver<DynamicMessage>(){

            public void onNext(DynamicMessage request) {
                if (firstResponse.get() != null) {
                    return;
                }
                GrpcRequest wireMockRequest = new GrpcRequest(serverAddress.scheme, serverAddress.hostname, serverAddress.port, ClientStreamingServerCallHandler.this.serviceDescriptor.getFullName(), ClientStreamingServerCallHandler.this.methodDescriptor.getName(), ClientStreamingServerCallHandler.this.jsonMessageConverter.toJson((MessageOrBuilder)request));
                ClientStreamingServerCallHandler.this.stubRequestHandler.handle((Request)wireMockRequest, (req, resp, attributes) -> {
                    HttpHeader statusHeader = resp.getHeaders().getHeader("grpc-status-name");
                    if (!statusHeader.isPresent() && resp.getStatus() == 404) {
                        return;
                    }
                    if (!statusHeader.isPresent() && GrpcStatusUtils.errorHttpToGrpcStatusMappings.containsKey(resp.getStatus())) {
                        Pair<Status, String> statusMapping = GrpcStatusUtils.errorHttpToGrpcStatusMappings.get(resp.getStatus());
                        Status grpcStatus = (Status)statusMapping.a;
                        WireMockGrpc.Status status = WireMockGrpc.Status.valueOf(grpcStatus.getCode().name());
                        responseStatus.set(status);
                        statusReason.set((String)statusMapping.b);
                        return;
                    }
                    if (statusHeader.isPresent() && !statusHeader.firstValue().equals(Status.Code.OK.name())) {
                        HttpHeader statusReasonHeader = resp.getHeaders().getHeader("grpc-status-reason");
                        String reason = statusReasonHeader.isPresent() ? statusReasonHeader.firstValue() : "";
                        WireMockGrpc.Status status = WireMockGrpc.Status.valueOf(statusHeader.firstValue());
                        responseStatus.set(status);
                        statusReason.set(reason);
                        return;
                    }
                    DynamicMessage.Builder messageBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)ClientStreamingServerCallHandler.this.methodDescriptor.getOutputType());
                    DynamicMessage response = (DynamicMessage)ClientStreamingServerCallHandler.this.jsonMessageConverter.toMessage(resp.getBodyAsString(), messageBuilder);
                    responseStatus.set(WireMockGrpc.Status.OK);
                    firstResponse.set(response);
                }, ServeEvent.of((Request)wireMockRequest));
            }

            public void onError(Throwable t) {
            }

            public void onCompleted() {
                if (responseStatus.get() != null && responseStatus.get() == WireMockGrpc.Status.OK) {
                    responseObserver.onNext((Object)((DynamicMessage)firstResponse.get()));
                    responseObserver.onCompleted();
                } else if (responseStatus.get() != null && responseStatus.get() != WireMockGrpc.Status.OK) {
                    responseObserver.onError((Throwable)Status.fromCodeValue((int)((WireMockGrpc.Status)((Object)responseStatus.get())).getValue()).withDescription((String)statusReason.get()).asRuntimeException());
                } else {
                    Pair<Status, String> notFoundStatusMapping = GrpcStatusUtils.errorHttpToGrpcStatusMappings.get(404);
                    Status grpcStatus = (Status)notFoundStatusMapping.a;
                    responseObserver.onError((Throwable)grpcStatus.withDescription((String)notFoundStatusMapping.b).asRuntimeException());
                }
            }
        };
    }
}

