/*
 * Decompiled with CFR 0.152.
 */
package org.wiremock.grpc.internal;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.common.Pair;
import com.github.tomakehurst.wiremock.http.StubRequestHandler;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import io.grpc.BindableService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.protobuf.ProtoServiceDescriptorSupplier;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.protobuf.services.ProtoReflectionServiceV1;
import io.grpc.servlet.jakarta.ServletAdapter;
import io.grpc.servlet.jakarta.ServletServerBuilder;
import io.grpc.stub.ServerCalls;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.wiremock.grpc.internal.ClientStreamingServerCallHandler;
import org.wiremock.grpc.internal.HeaderCopyingServerInterceptor;
import org.wiremock.grpc.internal.JsonMessageConverter;
import org.wiremock.grpc.internal.UnaryServerCallHandler;

public class GrpcFilter
extends HttpFilter {
    private ServletAdapter servletAdapter;
    private final StubRequestHandler stubRequestHandler;

    public GrpcFilter(StubRequestHandler stubRequestHandler) {
        this.stubRequestHandler = stubRequestHandler;
    }

    public void loadFileDescriptors(List<Descriptors.FileDescriptor> fileDescriptors) {
        List<BindableService> services = this.buildServices(fileDescriptors);
        this.servletAdapter = GrpcFilter.loadServices(services);
    }

    private static ServletAdapter loadServices(List<? extends BindableService> bindableServices) {
        HeaderCopyingServerInterceptor headerCopyingServerInterceptor = new HeaderCopyingServerInterceptor();
        ServletServerBuilder serverBuilder = new ServletServerBuilder();
        bindableServices.forEach(service -> serverBuilder.addService(ServerInterceptors.intercept((BindableService)service, (ServerInterceptor[])new ServerInterceptor[]{headerCopyingServerInterceptor})));
        return serverBuilder.buildServletAdapter();
    }

    private List<BindableService> buildServices(List<Descriptors.FileDescriptor> fileDescriptors) {
        TypeRegistry.Builder typeRegistryBuilder = TypeRegistry.newBuilder();
        fileDescriptors.forEach(fileDescriptor -> fileDescriptor.getMessageTypes().forEach(arg_0 -> ((TypeRegistry.Builder)typeRegistryBuilder).add(arg_0)));
        TypeRegistry typeRegistry = typeRegistryBuilder.build();
        JsonMessageConverter jsonMessageConverter = new JsonMessageConverter(typeRegistry);
        Stream<BindableService> servicesFromDescriptors = fileDescriptors.stream().flatMap(fileDescriptor -> fileDescriptor.getServices().stream().map(service -> Pair.pair((Object)fileDescriptor, (Object)service))).map(fileAndServiceDescriptor -> () -> {
            final Descriptors.FileDescriptor fileDescriptor = (Descriptors.FileDescriptor)fileAndServiceDescriptor.a;
            final Descriptors.ServiceDescriptor serviceDescriptor = (Descriptors.ServiceDescriptor)fileAndServiceDescriptor.b;
            ServiceDescriptor.Builder serviceDescriptorBuilder = ServiceDescriptor.newBuilder((String)serviceDescriptor.getFullName()).setSchemaDescriptor((Object)new ProtoServiceDescriptorSupplier(){

                public Descriptors.FileDescriptor getFileDescriptor() {
                    return fileDescriptor;
                }

                public Descriptors.ServiceDescriptor getServiceDescriptor() {
                    return serviceDescriptor;
                }
            });
            List<Pair> methodDescriptorHandlerPairs = serviceDescriptor.getMethods().stream().map(methodDescriptor -> Pair.pair(GrpcFilter.buildMessageDescriptorInstance(serviceDescriptor, methodDescriptor), this.buildHandler(serviceDescriptor, (Descriptors.MethodDescriptor)methodDescriptor, jsonMessageConverter))).collect(Collectors.toList());
            methodDescriptorHandlerPairs.stream().map(pair -> (MethodDescriptor)pair.a).forEach(arg_0 -> ((ServiceDescriptor.Builder)serviceDescriptorBuilder).addMethod(arg_0));
            ServerServiceDefinition.Builder builder = ServerServiceDefinition.builder((ServiceDescriptor)serviceDescriptorBuilder.build());
            methodDescriptorHandlerPairs.forEach(pair -> builder.addMethod((MethodDescriptor)pair.a, (ServerCallHandler)pair.b));
            return builder.build();
        });
        BindableService reflectionService = ProtoReflectionServiceV1.newInstance();
        return Stream.concat(servicesFromDescriptors, Stream.of(reflectionService)).collect(Collectors.toUnmodifiableList());
    }

    private ServerCallHandler<DynamicMessage, DynamicMessage> buildHandler(Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.MethodDescriptor methodDescriptor, JsonMessageConverter jsonMessageConverter) {
        return methodDescriptor.isClientStreaming() ? ServerCalls.asyncClientStreamingCall((ServerCalls.ClientStreamingMethod)new ClientStreamingServerCallHandler(this.stubRequestHandler, serviceDescriptor, methodDescriptor, jsonMessageConverter)) : ServerCalls.asyncUnaryCall((ServerCalls.UnaryMethod)new UnaryServerCallHandler(this.stubRequestHandler, serviceDescriptor, methodDescriptor, jsonMessageConverter));
    }

    private static MethodDescriptor<DynamicMessage, DynamicMessage> buildMessageDescriptorInstance(Descriptors.ServiceDescriptor serviceDescriptor, Descriptors.MethodDescriptor methodDescriptor) {
        return MethodDescriptor.newBuilder().setType(GrpcFilter.getMethodTypeFromDesc(methodDescriptor)).setFullMethodName(MethodDescriptor.generateFullMethodName((String)serviceDescriptor.getFullName(), (String)methodDescriptor.getName())).setRequestMarshaller(ProtoUtils.marshaller((Message)DynamicMessage.getDefaultInstance((Descriptors.Descriptor)methodDescriptor.getInputType()))).setResponseMarshaller(ProtoUtils.marshaller((Message)DynamicMessage.getDefaultInstance((Descriptors.Descriptor)methodDescriptor.getOutputType()))).build();
    }

    private static MethodDescriptor.MethodType getMethodTypeFromDesc(Descriptors.MethodDescriptor methodDesc) {
        if (!methodDesc.isServerStreaming() && !methodDesc.isClientStreaming()) {
            return MethodDescriptor.MethodType.UNARY;
        }
        if (methodDesc.isServerStreaming() && !methodDesc.isClientStreaming()) {
            return MethodDescriptor.MethodType.SERVER_STREAMING;
        }
        if (!methodDesc.isServerStreaming()) {
            return MethodDescriptor.MethodType.CLIENT_STREAMING;
        }
        return MethodDescriptor.MethodType.BIDI_STREAMING;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ServletAdapter.isGrpc((HttpServletRequest)request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        ServerAddress.set(request.getScheme(), request.getLocalAddr(), request.getLocalPort());
        String method = request.getMethod();
        if (GrpcFilter.isPost(method)) {
            this.servletAdapter.doPost(request, response);
        } else if (GrpcFilter.isGet(method)) {
            this.servletAdapter.doGet(request, response);
        }
    }

    public void destroy() {
        this.servletAdapter.destroy();
    }

    private static boolean isGet(String method) {
        return method.equalsIgnoreCase("GET");
    }

    private static boolean isPost(String method) {
        return method.equalsIgnoreCase("POST");
    }

    public static class ServerAddress {
        private static final CompletableFuture<ServerAddress> instance = new CompletableFuture();
        final String scheme;
        final String hostname;
        final int port;

        public static void set(String scheme, String hostname, int port) {
            instance.complete(new ServerAddress(scheme, hostname, port));
        }

        public static ServerAddress get() {
            return (ServerAddress)Exceptions.uncheck(() -> instance.get(5L, TimeUnit.SECONDS), ServerAddress.class);
        }

        public ServerAddress(String scheme, String hostname, int port) {
            this.scheme = scheme;
            this.hostname = hostname;
            this.port = port;
        }
    }
}

