/*
 * Decompiled with CFR 0.152.
 */
package org.zkforge.apache.commons.el;

import java.math.BigInteger;
import javax.servlet.jsp.el.ELException;
import org.zkforge.apache.commons.el.BinaryOperator;
import org.zkforge.apache.commons.el.Coercions;
import org.zkforge.apache.commons.el.Constants;
import org.zkforge.apache.commons.el.Logger;
import org.zkforge.apache.commons.el.PrimitiveObjects;

public class ModulusOperator
extends BinaryOperator {
    public static final ModulusOperator SINGLETON = new ModulusOperator();

    public String getOperatorSymbol() {
        return "%";
    }

    public Object apply(Object pLeft, Object pRight, Logger pLogger) throws ELException {
        if (pLeft == null && pRight == null) {
            if (pLogger.isLoggingWarning()) {
                pLogger.logWarning(Constants.ARITH_OP_NULL, this.getOperatorSymbol());
            }
            return PrimitiveObjects.getInteger(0);
        }
        if (pLeft != null && (Coercions.isFloatingPointType(pLeft) || Coercions.isFloatingPointString(pLeft)) || Coercions.isBigDecimal(pLeft) || pRight != null && (Coercions.isFloatingPointType(pRight) || Coercions.isFloatingPointString(pRight) || Coercions.isBigDecimal(pRight))) {
            double left = Coercions.coerceToPrimitiveNumber(pLeft, Double.class, pLogger).doubleValue();
            double right = Coercions.coerceToPrimitiveNumber(pRight, Double.class, pLogger).doubleValue();
            try {
                return PrimitiveObjects.getDouble(left % right);
            }
            catch (Exception exc) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.ARITH_ERROR, this.getOperatorSymbol(), (Object)("" + left), (Object)("" + right));
                }
                return PrimitiveObjects.getInteger(0);
            }
        }
        if (Coercions.isBigInteger(pLeft) || Coercions.isBigInteger(pRight)) {
            BigInteger left = (BigInteger)Coercions.coerceToPrimitiveNumber(pLeft, BigInteger.class, pLogger);
            BigInteger right = (BigInteger)Coercions.coerceToPrimitiveNumber(pRight, BigInteger.class, pLogger);
            try {
                return left.remainder(right);
            }
            catch (Exception exc) {
                if (pLogger.isLoggingError()) {
                    pLogger.logError(Constants.ARITH_ERROR, this.getOperatorSymbol(), (Object)("" + left), (Object)("" + right));
                }
                return PrimitiveObjects.getInteger(0);
            }
        }
        long left = Coercions.coerceToPrimitiveNumber(pLeft, Long.class, pLogger).longValue();
        long right = Coercions.coerceToPrimitiveNumber(pRight, Long.class, pLogger).longValue();
        try {
            return PrimitiveObjects.getLong(left % right);
        }
        catch (Exception exc) {
            if (pLogger.isLoggingError()) {
                pLogger.logError(Constants.ARITH_ERROR, this.getOperatorSymbol(), (Object)("" + left), (Object)("" + right));
            }
            return PrimitiveObjects.getInteger(0);
        }
    }
}

