/*
 * Decompiled with CFR 0.152.
 */
package pl.szczepanik.silencio.api;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import pl.szczepanik.silencio.core.IntegrityException;

public class Format {
    public static final Format PROPERTIES = new Format("PROPERTIES");
    public static final Format JSON = new Format("JSON");
    public static final Format XML = new Format("XML");
    private final String name;

    public Format(String name) {
        this.validateName(name);
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Format ref = (Format)obj;
        return new EqualsBuilder().append((Object)this.name, (Object)ref.name).isEquals();
    }

    private void validateName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IntegrityException("Name of the format must not be empty!");
        }
    }

    public String toString() {
        return String.format("Format [name='%s']", this.name);
    }
}

