/*
 * Decompiled with CFR 0.152.
 */
package pl.szczepanik.silencio.core;

import java.util.ArrayList;
import java.util.List;
import pl.szczepanik.silencio.api.Converter;
import pl.szczepanik.silencio.api.Decision;
import pl.szczepanik.silencio.api.Format;
import pl.szczepanik.silencio.api.Processor;
import pl.szczepanik.silencio.converters.BlankConverter;
import pl.szczepanik.silencio.converters.NumberSequenceConverter;
import pl.szczepanik.silencio.core.Configuration;
import pl.szczepanik.silencio.core.Execution;
import pl.szczepanik.silencio.core.IntegrityException;
import pl.szczepanik.silencio.decisions.PositiveDecision;
import pl.szczepanik.silencio.processors.AbstractProcessor;
import pl.szczepanik.silencio.processors.JSONProcessor;
import pl.szczepanik.silencio.processors.PropertiesProcessor;
import pl.szczepanik.silencio.processors.XMLProcessor;

public final class Builder {
    public static final Converter BLANK = new BlankConverter();
    public static final Converter NUMBER_SEQUENCE = new NumberSequenceConverter();
    private final Format format;
    private final List<Execution> executions = new ArrayList<Execution>();

    public Builder(Format format) {
        this.format = format;
    }

    public Builder with(Decision[] decisions, Converter[] converters) {
        this.executions.add(new Execution(decisions, converters));
        return this;
    }

    public Builder with(Decision decision, Converter ... converters) {
        return this.with(new Decision[]{decision}, converters);
    }

    public Builder with(Decision decision, Converter converter) {
        return this.with(decision, new Converter[]{converter});
    }

    public Builder with(Converter ... converters) {
        return this.with((Decision)new PositiveDecision(), converters);
    }

    public Builder with(Converter converter) {
        return this.with((Decision)new PositiveDecision(), new Converter[]{converter});
    }

    public Processor build() {
        AbstractProcessor processor;
        if (Format.JSON.equals(this.format)) {
            processor = new JSONProcessor();
        } else if (Format.XML.equals(this.format)) {
            processor = new XMLProcessor();
        } else if (Format.PROPERTIES.equals(this.format)) {
            processor = new PropertiesProcessor();
        } else {
            throw new IntegrityException("Unsupported format: " + this.format.getName());
        }
        Execution[] executionsArray = new Execution[this.executions.size()];
        this.executions.toArray(executionsArray);
        processor.setConfiguration(new Configuration(executionsArray));
        return processor;
    }

    public void clearExecutions() {
        this.executions.clear();
    }
}

