/*
 * Decompiled with CFR 0.152.
 */
package pl.szczepanik.silencio.core;

import org.apache.commons.lang3.ArrayUtils;
import pl.szczepanik.silencio.api.Converter;
import pl.szczepanik.silencio.api.Decision;
import pl.szczepanik.silencio.core.IntegrityException;

public class Execution {
    private final Decision[] decisions;
    private final Converter[] converters;

    public Execution(Decision[] decisions, Converter[] converters) {
        this.validateDecisions(decisions);
        this.validateConverters(converters);
        this.decisions = decisions;
        this.converters = converters;
    }

    public Execution(Decision decision, Converter[] converters) {
        this(new Decision[]{decision}, converters);
    }

    public Execution(Decision decision, Converter converter) {
        this(new Decision[]{decision}, new Converter[]{converter});
    }

    public Decision[] getDecisions() {
        return this.decisions;
    }

    public Converter[] getConverters() {
        return this.converters;
    }

    private void validateDecisions(Decision[] decisions) {
        if (ArrayUtils.isEmpty((Object[])decisions)) {
            throw new IntegrityException("Array with Decisions must not be empty!");
        }
        if (ArrayUtils.contains((Object[])decisions, null)) {
            throw new IntegrityException(String.format("Passed Decision is null!", new Object[0]));
        }
    }

    private void validateConverters(Converter[] converters) {
        if (ArrayUtils.isEmpty((Object[])converters)) {
            throw new IntegrityException("Array with Converters must not be empty!");
        }
        if (ArrayUtils.contains((Object[])converters, null)) {
            throw new IntegrityException(String.format("Passed Converter is null!", new Object[0]));
        }
    }
}

