/*
 * Decompiled with CFR 0.152.
 */
package pl.szczepanik.silencio.core;

import pl.szczepanik.silencio.core.ProcessorException;

public class ProcessorStateMachine {
    private static final String ERROR_MESSAGE = "This operation is not allowed for this state: ";
    private States state = States.CREATED;

    public void validateProcess() {
        if (this.state == States.CREATED) {
            throw new ProcessorException(ERROR_MESSAGE + this.state.name());
        }
    }

    public void validateWrite() {
        if (this.state != States.PROCESSED) {
            throw new ProcessorException(ERROR_MESSAGE + this.state.name());
        }
    }

    public void moveToLoaded() {
        this.state = States.LOADED;
    }

    public void moveToProcessed() {
        this.state = States.PROCESSED;
    }

    private static enum States {
        CREATED,
        LOADED,
        PROCESSED;

    }
}

