/*
 * Decompiled with CFR 0.152.
 */
package pl.szczepanik.silencio.diagnostics;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.paukov.combinatorics.Factory;
import org.paukov.combinatorics.Generator;
import org.paukov.combinatorics.ICombinatoricsVector;
import pl.szczepanik.silencio.api.Converter;
import pl.szczepanik.silencio.api.Decision;
import pl.szczepanik.silencio.api.Processor;
import pl.szczepanik.silencio.converters.BlankConverter;
import pl.szczepanik.silencio.core.Configuration;
import pl.szczepanik.silencio.core.Execution;
import pl.szczepanik.silencio.decisions.MatcherDecision;
import pl.szczepanik.silencio.decisions.NegativeDecision;
import pl.szczepanik.silencio.decisions.PositiveDecision;
import pl.szczepanik.silencio.diagnostics.ConstantValueConverter;
import pl.szczepanik.silencio.diagnostics.KeyValueConverter;
import pl.szczepanik.silencio.diagnostics.PassedValueConverter;
import pl.szczepanik.silencio.diagnostics.WhiteCharConverter;

public final class ProcessorSmokeChecker {
    private static final Converter[] CONVERTERS = new Converter[]{new BlankConverter(), new WhiteCharConverter(), new ConstantValueConverter(), new KeyValueConverter(), new PassedValueConverter()};
    private static final Decision[] DECISIONS = new Decision[]{new PositiveDecision(), new NegativeDecision(), new MatcherDecision(".*")};
    private final Processor processor;

    public ProcessorSmokeChecker(Processor processor) {
        this.processor = processor;
    }

    public void validateWithAllCombinations(String content) {
        ICombinatoricsVector allConverters = Factory.createVector((Object[])CONVERTERS);
        Generator subSet = Factory.createSubSetGenerator((ICombinatoricsVector)allConverters);
        for (ICombinatoricsVector subConverters : subSet) {
            if (subConverters.getSize() == 0) continue;
            Converter[] converters = subConverters.getVector().toArray(new Converter[subConverters.getSize()]);
            this.validateWithSetsOfDecisions(converters, content);
        }
    }

    private void validateWithSetsOfDecisions(Converter[] converters, String content) {
        ICombinatoricsVector allDecisions = Factory.createVector((Object[])DECISIONS);
        Generator subSet = Factory.createSubSetGenerator((ICombinatoricsVector)allDecisions);
        for (ICombinatoricsVector subDecisions : subSet) {
            if (subDecisions.getSize() == 0) continue;
            Decision[] decisions = subDecisions.getVector().toArray(new Decision[subDecisions.getSize()]);
            Execution[] executions = new Execution[]{new Execution(decisions, converters)};
            this.validateProcessor(executions, content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateProcessor(Execution[] executions, String content) {
        StringWriter output = new StringWriter();
        StringReader input = new StringReader(content);
        try {
            this.processor.setConfiguration(new Configuration(executions));
            this.processor.load(input);
            this.processor.process();
            this.processor.write(output);
        }
        finally {
            IOUtils.closeQuietly((Reader)input);
            IOUtils.closeQuietly((Writer)output);
        }
    }
}

