/*
 * Decompiled with CFR 0.152.
 */
package pl.szczepanik.silencio.processors;

import java.io.Reader;
import java.io.Writer;
import pl.szczepanik.silencio.api.Converter;
import pl.szczepanik.silencio.api.Format;
import pl.szczepanik.silencio.api.Processor;
import pl.szczepanik.silencio.core.Configuration;
import pl.szczepanik.silencio.core.Execution;
import pl.szczepanik.silencio.core.IntegrityException;
import pl.szczepanik.silencio.core.ProcessorStateMachine;

public abstract class AbstractProcessor
implements Processor {
    protected final Format format;
    protected Configuration configuration;
    private final ProcessorStateMachine stateMachine = new ProcessorStateMachine();

    public AbstractProcessor(Format format) {
        this.validateFormat(format);
        this.format = format;
    }

    @Override
    public Format getFormat() {
        return this.format;
    }

    protected void initConverties() {
        for (Execution execution : this.configuration.getExecutions()) {
            for (Converter converter : execution.getConverters()) {
                converter.init();
            }
        }
    }

    @Override
    public final void load(Reader reader) {
        this.realLoad(reader);
    }

    protected abstract void realLoad(Reader var1);

    @Override
    public void setConfiguration(Configuration configuration) {
        this.validateConfiguration(configuration);
        this.configuration = configuration;
        this.stateMachine.moveToLoaded();
    }

    @Override
    public final void process() {
        this.stateMachine.validateProcess();
        this.initConverties();
        this.realProcess();
        this.stateMachine.moveToProcessed();
    }

    protected abstract void realProcess();

    @Override
    public final void write(Writer writer) {
        this.stateMachine.validateWrite();
        this.realWrite(writer);
    }

    protected abstract void realWrite(Writer var1);

    private void validateFormat(Format format) {
        if (format == null) {
            throw new IntegrityException("Format must not be null!");
        }
    }

    private void validateConfiguration(Configuration configuration) {
        if (configuration == null) {
            throw new IntegrityException("Configuration must not be null!");
        }
    }
}

