/*
 * Decompiled with CFR 0.152.
 */
package pl.szczepanik.silencio.processors;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import pl.szczepanik.silencio.api.Format;
import pl.szczepanik.silencio.core.ProcessorException;
import pl.szczepanik.silencio.processors.AbstractProcessor;
import pl.szczepanik.silencio.processors.visitors.PropertiesVisitor;

public class PropertiesProcessor
extends AbstractProcessor {
    private final Properties properties = new Properties();
    private final PropertiesVisitor visitor = new PropertiesVisitor();

    public PropertiesProcessor() {
        super(Format.PROPERTIES);
    }

    @Override
    public void realLoad(Reader reader) {
        this.properties.clear();
        try {
            this.properties.load(reader);
        }
        catch (IOException | IllegalArgumentException e) {
            throw new ProcessorException(e);
        }
    }

    @Override
    public void realProcess() {
        this.visitor.setConfiguration(this.configuration);
        this.visitor.process(this.properties);
    }

    @Override
    public void realWrite(Writer writer) {
        try {
            this.properties.store(writer, null);
        }
        catch (IOException e) {
            throw new ProcessorException(e);
        }
    }
}

