/*
 * Decompiled with CFR 0.152.
 */
package pl.szczepanik.silencio.processors.visitors;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import pl.szczepanik.silencio.core.Key;
import pl.szczepanik.silencio.core.ProcessorException;
import pl.szczepanik.silencio.processors.visitors.AbstractVisitor;

public class JSONVisitor
extends AbstractVisitor {
    public void processJSON(Map<String, Object> json) {
        this.processMap(json);
    }

    private void processComplex(String key, Object value) {
        if (this.isMap(value)) {
            this.processMap((Map)value);
        } else if (this.isArray(value)) {
            this.processArray(key, (List)value);
        } else {
            throw new ProcessorException("Unknown type of the key: " + value.getClass().getName());
        }
    }

    private void processMap(Map<String, Object> map) {
        for (Map.Entry<String, Object> keyMap : map.entrySet()) {
            String key = keyMap.getKey();
            Object value = keyMap.getValue();
            if (this.isBasicType(value)) {
                map.put(key, this.processValue(new Key(key), value).getValue());
                continue;
            }
            this.processComplex(key, value);
        }
    }

    private void processArray(String key, List<Object> list) {
        for (int i = 0; i < list.size(); ++i) {
            Object value = list.get(i);
            if (this.isBasicType(value)) {
                list.set(i, this.processValue(new Key(key), value).getValue());
                continue;
            }
            this.processComplex(key, value);
        }
    }

    private boolean isMap(Object value) {
        return value instanceof Map;
    }

    private boolean isArray(Object value) {
        return value instanceof List;
    }

    private boolean isBasicType(Object value) {
        return value instanceof String || value instanceof Integer || value instanceof Long || value instanceof BigInteger || value instanceof BigDecimal || value instanceof Double || value instanceof Boolean || value == null;
    }
}

