package org.codehaus.plexus.action;

/*
 * Copyright (c) 2004, Codehaus.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.ServiceLocator;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Serviceable;

/**
 * @plexus.component
 *  lifecycle-handler="plexus-configurable"
 *
 * @author <a href="mailto:jason@maven.org">Jason van Zyl</a>
 * @version $Id: DefaultActionManager.java 2030 2005-05-29 08:11:05Z trygvis $
 */
public class DefaultActionManager
    extends AbstractLogEnabled
    implements ActionManager, Serviceable
{
    private ServiceLocator locator;

    // ----------------------------------------------------------------------
    // ActionManager Implementation
    // ----------------------------------------------------------------------

    public Action lookup( String id )
        throws ActionNotFoundException
    {
        try
        {
            if ( !locator.hasComponent( Action.ROLE, id ) )
            {
                throw new ActionNotFoundException( "Cannot find action: " + id );
            }

            return (Action) locator.lookup( Action.ROLE, id );
        }
        catch ( ComponentLookupException e )
        {
            throw new ActionNotFoundException( "Cannot find action: " + id, e );
        }
    }

    // ----------------------------------------------------------------------
    // Component Lifecycle
    // ----------------------------------------------------------------------

    public void service( ServiceLocator locator )
    {
        this.locator = locator;
    }
}

