/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.factory.bsh;

import bsh.EvalError;
import bsh.Interpreter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.factory.AbstractComponentFactory;
import org.codehaus.plexus.component.factory.ComponentInstantiationException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.util.IOUtil;

public class BshComponentFactory
extends AbstractComponentFactory {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object newInstance(ComponentDescriptor componentDescriptor, ClassRealm containerRealm, PlexusContainer container) throws ComponentInstantiationException {
        URL scriptLocation;
        String impl = componentDescriptor.getImplementation();
        if (!impl.startsWith("/")) {
            impl = "/" + impl;
        }
        if ((scriptLocation = containerRealm.getResource(impl)) == null) {
            StringBuffer buf = new StringBuffer("Cannot find: " + impl + " in classpath:");
            int i = 0;
            while (i < containerRealm.getConstituents().length) {
                URL constituent = containerRealm.getConstituents()[i];
                buf.append("\n   [" + i + "]  " + constituent);
                ++i;
            }
            throw new ComponentInstantiationException(buf.toString());
        }
        Object result = null;
        InputStreamReader reader = null;
        try {
            Interpreter interp = new Interpreter();
            reader = new InputStreamReader(scriptLocation.openStream());
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(containerRealm.getClassLoader());
            result = interp.eval((Reader)reader);
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        catch (EvalError evalError) {
            try {
                containerRealm.display();
                container.getLogger().info("Error text: " + evalError.getErrorText());
                throw new ComponentInstantiationException("Cannot build component for: " + componentDescriptor.getComponentKey() + "; unable to read BeanShell script", (Throwable)evalError);
                catch (FileNotFoundException e) {
                    containerRealm.display();
                    throw new ComponentInstantiationException("Cannot build component for: " + componentDescriptor.getComponentKey() + "; unable to read BeanShell script", (Throwable)e);
                }
                catch (IOException e) {
                    throw new ComponentInstantiationException("Cannot build component for: " + componentDescriptor.getComponentKey() + "; unable to read BeanShell script", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        return result;
    }
}

