/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.formica.population;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.codehaus.plexus.formica.Element;
import org.codehaus.plexus.formica.ElementGroup;
import org.codehaus.plexus.formica.Form;
import org.codehaus.plexus.formica.population.AbstractPopulator;
import org.codehaus.plexus.formica.population.TargetPopulationException;

public class OgnlPopulator
extends AbstractPopulator {
    public void populate(Form form, Map data, Object target) throws TargetPopulationException {
        if (form.getElements() != null) {
            this.populateElements(data, target, form.getElements(), form.getId());
        }
        if (form.getElementGroups() != null) {
            Iterator itr = form.getElementGroups().iterator();
            while (itr.hasNext()) {
                ElementGroup group = (ElementGroup)itr.next();
                if (group.getElements() == null) continue;
                this.populateElements(data, target, group.getElements(), form.getId());
            }
        }
    }

    private void populateElements(Map data, Object target, List elements, String formId) throws TargetPopulationException {
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            String id = element.getId();
            Object elementData = data.get(id);
            if (elementData == null && element.getDefaultValue() != null) {
                elementData = element.getDefaultValue();
            }
            if (elementData instanceof String) {
                String s = (String)elementData;
                if (s.equals("false") || s.equals("off") || s.equals("0")) {
                    elementData = Boolean.FALSE;
                } else if (s.equals("true") || s.equals("on") || s.equals("1")) {
                    elementData = Boolean.TRUE;
                }
            }
            if (elementData == null) continue;
            String expression = element.getExpression();
            if (expression == null) {
                throw new TargetPopulationException("Expression for " + element.getId() + " in " + formId + " cannot be null.");
            }
            try {
                Ognl.setValue((String)expression, (Map)data, (Object)target, elementData);
            }
            catch (OgnlException e) {
                throw new TargetPopulationException(e);
            }
        }
    }
}

